/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.computer;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.Computer;
import com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.AnnotationKind;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.Range;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiagnosticIgnoranceComputer
implements Computer<Data> {
    private static final DiagnosticCode ALL_DIAGNOSTICS_KEY;
    private static final Pattern IGNORE_ALL_ON;
    private static final Pattern IGNORE_ALL_OFF;
    private static final Pattern IGNORE_DIAGNOSTIC_ON;
    private static final Pattern IGNORE_DIAGNOSTIC_OFF;
    private final DocumentContext documentContext;
    private final Map<DiagnosticCode, List<Range<Integer>>> diagnosticIgnorance = new HashMap();
    private final Map<DiagnosticCode, Deque<Integer>> ignoranceStack = new HashMap();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DiagnosticIgnoranceComputer(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }

    public Data compute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AjcClosure1 ajcClosure1 = new AjcClosure1(objectArray);
        return (Data)MeasuresAspect.aspectOf().measureComputers(ajcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void computeExtensionIgnorance() {
        TreeMap lines = new TreeMap();
        this.documentContext.getSymbolTree().getMethods().stream().filter(method -> method.getAnnotations().stream().map(Annotation::getKind).anyMatch(kind -> kind == AnnotationKind.CHANGEANDVALIDATE)).forEach(methodSymbol -> {
            lines.put(methodSymbol.getRange().getStart().getLine(), true);
            lines.put(methodSymbol.getRange().getEnd().getLine(), false);
        });
        if (lines.isEmpty()) {
            return;
        }
        this.documentContext.getTokens().stream().filter(token -> token.getChannel() == 1).filter(token -> token.getType() == 25 || token.getType() == 26).forEach(token -> lines.put(token.getLine(), token.getType() == 26));
        int lastTokenLine = -1;
        int tokenLine = -1;
        for (Map.Entry entry : lines.entrySet()) {
            if (Boolean.TRUE.equals(entry.getValue())) {
                tokenLine = (Integer)entry.getKey();
                continue;
            }
            lastTokenLine = (Integer)entry.getKey();
            this.addIgnoredRange(ALL_DIAGNOSTICS_KEY, tokenLine, lastTokenLine);
        }
    }

    private void computeCommentsIgnorance(List<Token> codeTokens) {
        Set codeLines = codeTokens.stream().map(Token::getLine).collect(Collectors.toSet());
        List comments = this.documentContext.getComments();
        for (Token comment : comments) {
            boolean bl = this.checkTrailingComment(codeLines, comment) || this.checkIgnoreOff(IGNORE_ALL_OFF, comment) != null || this.checkIgnoreOn(IGNORE_ALL_ON, comment) || this.checkIgnoreOff(IGNORE_DIAGNOSTIC_OFF, comment) != null || this.checkIgnoreOn(IGNORE_DIAGNOSTIC_ON, comment);
        }
        int lastTokenLine = codeTokens.get(codeTokens.size() - 1).getLine();
        this.ignoranceStack.forEach((diagnosticKey, ignoreRangeStarts) -> ignoreRangeStarts.forEach(ignoreRangeStart -> this.addIgnoredRange(diagnosticKey, ignoreRangeStart.intValue(), lastTokenLine)));
    }

    private boolean checkTrailingComment(Set<Integer> codeLines, Token comment) {
        int commentLine = comment.getLine();
        if (!codeLines.contains(commentLine)) {
            return false;
        }
        DiagnosticCode key = this.checkIgnoreOff(IGNORE_ALL_OFF, comment);
        if (key == null) {
            key = this.checkIgnoreOff(IGNORE_DIAGNOSTIC_OFF, comment);
        }
        if (key == null) {
            return false;
        }
        Deque stack = (Deque)this.ignoranceStack.get(key);
        stack.pop();
        this.addIgnoredRange(key, commentLine, commentLine);
        return true;
    }

    @Nullable
    private DiagnosticCode checkIgnoreOff(Pattern ignoreOff, Token comment) {
        Matcher matcher = ignoreOff.matcher(comment.getText());
        if (!matcher.find()) {
            return null;
        }
        DiagnosticCode key = DiagnosticIgnoranceComputer.getKey((Matcher)matcher);
        Deque stack = this.ignoranceStack.computeIfAbsent(key, s -> new ArrayDeque());
        stack.push(comment.getLine());
        return key;
    }

    private boolean checkIgnoreOn(Pattern ignoreOn, Token comment) {
        Matcher matcher = ignoreOn.matcher(comment.getText());
        if (!matcher.find()) {
            return false;
        }
        DiagnosticCode key = DiagnosticIgnoranceComputer.getKey((Matcher)matcher);
        Deque stack = this.ignoranceStack.computeIfAbsent(key, s -> new ArrayDeque());
        if (stack.isEmpty()) {
            return false;
        }
        int ignoreRangeStart = (Integer)stack.pop();
        int ignoreRangeEnd = comment.getLine();
        this.addIgnoredRange(key, ignoreRangeStart, ignoreRangeEnd);
        return true;
    }

    private void addIgnoredRange(DiagnosticCode diagnosticKey, int ignoreRangeStart, int ignoreRangeEnd) {
        Range ignoreRange = Range.between((Comparable)Integer.valueOf(ignoreRangeStart - 1), (Comparable)Integer.valueOf(ignoreRangeEnd - 1));
        List ranges = this.diagnosticIgnorance.computeIfAbsent(diagnosticKey, s -> new ArrayList());
        ranges.add(ignoreRange);
    }

    private static DiagnosticCode getKey(Matcher matcher) {
        DiagnosticCode key = matcher.groupCount() != 0 ? new DiagnosticCode(matcher.group(1)) : ALL_DIAGNOSTICS_KEY;
        return key;
    }

    static {
        DiagnosticIgnoranceComputer.ajc$preClinit();
        ALL_DIAGNOSTICS_KEY = new DiagnosticCode("all");
        IGNORE_ALL_ON = CaseInsensitivePattern.compile((String)"BSLLS-(?:\u0432\u043a\u043b|on)");
        IGNORE_ALL_OFF = CaseInsensitivePattern.compile((String)"BSLLS-(?:\u0432\u044b\u043a\u043b|off)");
        IGNORE_DIAGNOSTIC_ON = CaseInsensitivePattern.compile((String)"BSLLS:(\\w+)-(?:\u0432\u043a\u043b|on)");
        IGNORE_DIAGNOSTIC_OFF = CaseInsensitivePattern.compile((String)"BSLLS:(\\w+)-(?:\u0432\u044b\u043a\u043b|off)");
    }

    static final /* synthetic */ Data compute_aroundBody0(DiagnosticIgnoranceComputer ajc$this, JoinPoint joinPoint) {
        ajc$this.diagnosticIgnorance.clear();
        ajc$this.ignoranceStack.clear();
        List codeTokens = ajc$this.documentContext.getTokensFromDefaultChannel();
        if (codeTokens.isEmpty()) {
            return new Data(ajc$this.diagnosticIgnorance);
        }
        ajc$this.computeCommentsIgnorance(codeTokens);
        ajc$this.computeExtensionIgnorance();
        return new Data(ajc$this.diagnosticIgnorance);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DiagnosticIgnoranceComputer.java", DiagnosticIgnoranceComputer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compute", "com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer", "", "", "", "com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer$Data"), 85);
    }
}

