/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Describable;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Exportable;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTreeVisitor;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.CompilerDirectiveKind;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

public final class MethodSymbol
implements SourceDefinedSymbol,
Exportable,
Describable {
    private final String name;
    private final SymbolKind symbolKind;
    private final DocumentContext owner;
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;
    private final int subNameLine;
    private final int subNameStartCharacter;
    private final int subNameEndCharacter;
    private Optional<SourceDefinedSymbol> parent;
    private final List<SourceDefinedSymbol> children;
    private final boolean function;
    private final boolean export;
    private final Optional<MethodDescription> description;
    private final boolean deprecated;
    private final List<ParameterDefinition> parameters;
    private final Optional<CompilerDirectiveKind> compilerDirectiveKind;
    private final List<Annotation> annotations;

    public Range getRange() {
        return Ranges.create((int)this.startLine, (int)this.startCharacter, (int)this.endLine, (int)this.endCharacter);
    }

    public Range getSubNameRange() {
        return Ranges.create((int)this.subNameLine, (int)this.subNameStartCharacter, (int)this.subNameLine, (int)this.subNameEndCharacter);
    }

    public Optional<RegionSymbol> getRegion() {
        return this.getParent().filter(RegionSymbol.class::isInstance).map(RegionSymbol.class::cast);
    }

    public void accept(SymbolTreeVisitor visitor) {
        visitor.visitMethod(this);
    }

    public Range getSelectionRange() {
        return this.getSubNameRange();
    }

    public static MethodSymbolBuilder builder() {
        return new MethodSymbolBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static SymbolKind $default$symbolKind() {
        return SymbolKind.Method;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Optional<SourceDefinedSymbol> $default$parent() {
        return Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static List<SourceDefinedSymbol> $default$children() {
        return new ArrayList<SourceDefinedSymbol>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static List<ParameterDefinition> $default$parameters() {
        return new ArrayList<ParameterDefinition>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Optional<CompilerDirectiveKind> $default$compilerDirectiveKind() {
        return Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static List<Annotation> $default$annotations() {
        return new ArrayList<Annotation>();
    }

    @ConstructorProperties(value={"name", "symbolKind", "owner", "startLine", "startCharacter", "endLine", "endCharacter", "subNameLine", "subNameStartCharacter", "subNameEndCharacter", "parent", "children", "function", "export", "description", "deprecated", "parameters", "compilerDirectiveKind", "annotations"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    MethodSymbol(String name, SymbolKind symbolKind, DocumentContext owner, int startLine, int startCharacter, int endLine, int endCharacter, int subNameLine, int subNameStartCharacter, int subNameEndCharacter, Optional<SourceDefinedSymbol> parent, List<SourceDefinedSymbol> children, boolean function, boolean export, Optional<MethodDescription> description, boolean deprecated, List<ParameterDefinition> parameters, Optional<CompilerDirectiveKind> compilerDirectiveKind, List<Annotation> annotations) {
        this.name = name;
        this.symbolKind = symbolKind;
        this.owner = owner;
        this.startLine = startLine;
        this.startCharacter = startCharacter;
        this.endLine = endLine;
        this.endCharacter = endCharacter;
        this.subNameLine = subNameLine;
        this.subNameStartCharacter = subNameStartCharacter;
        this.subNameEndCharacter = subNameEndCharacter;
        this.parent = parent;
        this.children = children;
        this.function = function;
        this.export = export;
        this.description = description;
        this.deprecated = deprecated;
        this.parameters = parameters;
        this.compilerDirectiveKind = compilerDirectiveKind;
        this.annotations = annotations;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SymbolKind getSymbolKind() {
        return this.symbolKind;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocumentContext getOwner() {
        return this.owner;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SourceDefinedSymbol> getChildren() {
        return this.children;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isFunction() {
        return this.function;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isExport() {
        return this.export;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<MethodDescription> getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<CompilerDirectiveKind> getCompilerDirectiveKind() {
        return this.compilerDirectiveKind;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodSymbol)) {
            return false;
        }
        MethodSymbol other = (MethodSymbol)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DocumentContext this$owner = this.getOwner();
        DocumentContext other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Range this$$getSubNameRange = this.getSubNameRange();
        Range other$$getSubNameRange = other.getSubNameRange();
        return !(this$$getSubNameRange == null ? other$$getSubNameRange != null : !this$$getSubNameRange.equals(other$$getSubNameRange));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DocumentContext $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Range $$getSubNameRange = this.getSubNameRange();
        result = result * 59 + ($$getSubNameRange == null ? 43 : $$getSubNameRange.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MethodSymbol(name=" + this.getName() + ", symbolKind=" + this.getSymbolKind() + ", owner=" + this.getOwner() + ", startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ", subNameLine=" + this.subNameLine + ", subNameStartCharacter=" + this.subNameStartCharacter + ", subNameEndCharacter=" + this.subNameEndCharacter + ", function=" + this.isFunction() + ", export=" + this.isExport() + ", description=" + this.getDescription() + ", deprecated=" + this.isDeprecated() + ", parameters=" + this.getParameters() + ", compilerDirectiveKind=" + this.getCompilerDirectiveKind() + ", annotations=" + this.getAnnotations() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<SourceDefinedSymbol> getParent() {
        return this.parent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setParent(Optional<SourceDefinedSymbol> parent) {
        this.parent = parent;
    }
}

