/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol.description;

import com.github._1c_syntax.bsl.languageserver.context.symbol.description.DescriptionReader;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.SourceDefinedSymbolDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.TypeDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionParser;
import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionTokenizer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.Range;

public final class MethodDescription
implements SourceDefinedSymbolDescription {
    private final String description;
    private final String deprecationInfo;
    private final boolean deprecated;
    private final String purposeDescription;
    private final List<String> examples;
    private final List<String> callOptions;
    private final List<ParameterDescription> parameters;
    private final List<TypeDescription> returnedValue;
    private final String link;
    private final Range range;

    public MethodDescription(List<Token> comments) {
        this.description = comments.stream().map(Token::getText).collect(Collectors.joining("\n"));
        BSLMethodDescriptionTokenizer tokenizer = new BSLMethodDescriptionTokenizer(this.description);
        BSLMethodDescriptionParser.MethodDescriptionContext ast = Objects.requireNonNull((BSLMethodDescriptionParser.MethodDescriptionContext)tokenizer.getAst());
        this.purposeDescription = DescriptionReader.readPurposeDescription((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.link = DescriptionReader.readLink((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.deprecated = ast.deprecate() != null;
        this.deprecationInfo = DescriptionReader.readDeprecationInfo((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.callOptions = DescriptionReader.readCallOptions((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.examples = DescriptionReader.readExamples((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.parameters = DescriptionReader.readParameters((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.returnedValue = DescriptionReader.readReturnedValue((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        if (comments.isEmpty()) {
            this.range = Ranges.create();
            return;
        }
        this.range = Ranges.create(comments);
    }

    public boolean contains(Token first, Token last) {
        return Ranges.containsRange((Range)this.range, (Range)Ranges.create((Token)first, (Token)last));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDeprecationInfo() {
        return this.deprecationInfo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPurposeDescription() {
        return this.purposeDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getExamples() {
        return this.examples;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getCallOptions() {
        return this.callOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ParameterDescription> getParameters() {
        return this.parameters;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<TypeDescription> getReturnedValue() {
        return this.returnedValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLink() {
        return this.link;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Range getRange() {
        return this.range;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodDescription)) {
            return false;
        }
        MethodDescription other = (MethodDescription)o;
        if (this.isDeprecated() != other.isDeprecated()) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationInfo = this.getDeprecationInfo();
        String other$deprecationInfo = other.getDeprecationInfo();
        if (this$deprecationInfo == null ? other$deprecationInfo != null : !this$deprecationInfo.equals(other$deprecationInfo)) {
            return false;
        }
        String this$purposeDescription = this.getPurposeDescription();
        String other$purposeDescription = other.getPurposeDescription();
        if (this$purposeDescription == null ? other$purposeDescription != null : !this$purposeDescription.equals(other$purposeDescription)) {
            return false;
        }
        List this$examples = this.getExamples();
        List other$examples = other.getExamples();
        if (this$examples == null ? other$examples != null : !((Object)this$examples).equals(other$examples)) {
            return false;
        }
        List this$callOptions = this.getCallOptions();
        List other$callOptions = other.getCallOptions();
        if (this$callOptions == null ? other$callOptions != null : !((Object)this$callOptions).equals(other$callOptions)) {
            return false;
        }
        List this$parameters = this.getParameters();
        List other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List this$returnedValue = this.getReturnedValue();
        List other$returnedValue = other.getReturnedValue();
        if (this$returnedValue == null ? other$returnedValue != null : !((Object)this$returnedValue).equals(other$returnedValue)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        return !(this$range == null ? other$range != null : !this$range.equals(other$range));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeprecated() ? 79 : 97);
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationInfo = this.getDeprecationInfo();
        result = result * 59 + ($deprecationInfo == null ? 43 : $deprecationInfo.hashCode());
        String $purposeDescription = this.getPurposeDescription();
        result = result * 59 + ($purposeDescription == null ? 43 : $purposeDescription.hashCode());
        List $examples = this.getExamples();
        result = result * 59 + ($examples == null ? 43 : ((Object)$examples).hashCode());
        List $callOptions = this.getCallOptions();
        result = result * 59 + ($callOptions == null ? 43 : ((Object)$callOptions).hashCode());
        List $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List $returnedValue = this.getReturnedValue();
        result = result * 59 + ($returnedValue == null ? 43 : ((Object)$returnedValue).hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MethodDescription(description=" + this.getDescription() + ", deprecationInfo=" + this.getDeprecationInfo() + ", deprecated=" + this.isDeprecated() + ", purposeDescription=" + this.getPurposeDescription() + ", examples=" + this.getExamples() + ", callOptions=" + this.getCallOptions() + ", parameters=" + this.getParameters() + ", returnedValue=" + this.getReturnedValue() + ", link=" + this.getLink() + ", range=" + this.getRange() + ")";
    }
}

