/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.symbol.variable;

import com.github._1c_syntax.bsl.languageserver.context.symbol.description.DescriptionReader;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.SourceDefinedSymbolDescription;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionParser;
import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionTokenizer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.Range;

public final class VariableDescription
implements SourceDefinedSymbolDescription {
    private final String description;
    private final String deprecationInfo;
    private final boolean deprecated;
    private final String purposeDescription;
    private final String link;
    private final Range range;
    private final Optional<VariableDescription> trailingDescription;

    public VariableDescription(List<Token> comments) {
        this(comments, Optional.empty());
    }

    public VariableDescription(List<Token> comments, Optional<Token> trailingComment) {
        this.description = comments.stream().map(Token::getText).collect(Collectors.joining("\n"));
        BSLMethodDescriptionTokenizer tokenizer = new BSLMethodDescriptionTokenizer(this.description);
        BSLMethodDescriptionParser.MethodDescriptionContext ast = Objects.requireNonNull((BSLMethodDescriptionParser.MethodDescriptionContext)tokenizer.getAst());
        this.range = Ranges.create(comments);
        this.purposeDescription = DescriptionReader.readPurposeDescription((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.link = DescriptionReader.readLink((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.deprecated = ast.deprecate() != null;
        this.deprecationInfo = DescriptionReader.readDeprecationInfo((BSLMethodDescriptionParser.MethodDescriptionContext)ast);
        this.trailingDescription = trailingComment.map(List::of).map(VariableDescription::new);
    }

    public VariableDescription(ParameterDescription param) {
        this.description = "";
        this.deprecationInfo = "";
        this.deprecated = false;
        this.purposeDescription = "";
        this.range = Ranges.create();
        this.link = param.getLink();
        this.trailingDescription = Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDeprecationInfo() {
        return this.deprecationInfo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPurposeDescription() {
        return this.purposeDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLink() {
        return this.link;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Range getRange() {
        return this.range;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<VariableDescription> getTrailingDescription() {
        return this.trailingDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableDescription)) {
            return false;
        }
        VariableDescription other = (VariableDescription)o;
        if (this.isDeprecated() != other.isDeprecated()) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$deprecationInfo = this.getDeprecationInfo();
        String other$deprecationInfo = other.getDeprecationInfo();
        if (this$deprecationInfo == null ? other$deprecationInfo != null : !this$deprecationInfo.equals(other$deprecationInfo)) {
            return false;
        }
        String this$purposeDescription = this.getPurposeDescription();
        String other$purposeDescription = other.getPurposeDescription();
        if (this$purposeDescription == null ? other$purposeDescription != null : !this$purposeDescription.equals(other$purposeDescription)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !this$range.equals(other$range)) {
            return false;
        }
        Optional this$trailingDescription = this.getTrailingDescription();
        Optional other$trailingDescription = other.getTrailingDescription();
        return !(this$trailingDescription == null ? other$trailingDescription != null : !((Object)this$trailingDescription).equals(other$trailingDescription));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeprecated() ? 79 : 97);
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $deprecationInfo = this.getDeprecationInfo();
        result = result * 59 + ($deprecationInfo == null ? 43 : $deprecationInfo.hashCode());
        String $purposeDescription = this.getPurposeDescription();
        result = result * 59 + ($purposeDescription == null ? 43 : $purposeDescription.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        Optional $trailingDescription = this.getTrailingDescription();
        result = result * 59 + ($trailingDescription == null ? 43 : ((Object)$trailingDescription).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "VariableDescription(description=" + this.getDescription() + ", deprecationInfo=" + this.getDeprecationInfo() + ", deprecated=" + this.isDeprecated() + ", purposeDescription=" + this.getPurposeDescription() + ", link=" + this.getLink() + ", range=" + this.getRange() + ", trailingDescription=" + this.getTrailingDescription() + ")";
    }
}

