/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.mdo.CommonModule;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Range;

abstract class AbstractCommonModuleNameDiagnostic
extends AbstractDiagnostic {
    protected Pattern pattern;
    private final LanguageServerConfiguration serverConfiguration;

    protected AbstractCommonModuleNameDiagnostic(LanguageServerConfiguration serverConfiguration, String regexp) {
        this.serverConfiguration = serverConfiguration;
        this.pattern = CaseInsensitivePattern.compile((String)regexp);
    }

    protected void check() {
        Range range = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (Ranges.isEmpty((Range)range)) {
            return;
        }
        this.documentContext.getMdObject().filter(CommonModule.class::isInstance).map(CommonModule.class::cast).filter(arg_0 -> this.flagsCheck(arg_0)).map(CommonModule::getName).map(this.pattern::matcher).filter(arg_0 -> this.matchCheck(arg_0)).ifPresent(commonModule -> this.diagnosticStorage.addDiagnostic(range));
    }

    protected abstract boolean flagsCheck(CommonModule var1);

    protected boolean matchCheck(Matcher matcher) {
        return !matcher.find();
    }

    protected boolean isClientServer(CommonModule commonModule) {
        return !commonModule.isServerCall() && commonModule.isServer() && commonModule.isExternalConnection() && this.isClientApplication(commonModule);
    }

    protected boolean isClient(CommonModule commonModule) {
        return !commonModule.isServerCall() && !commonModule.isServer() && !commonModule.isExternalConnection() && this.isClientApplication(commonModule);
    }

    protected boolean isServerCall(CommonModule commonModule) {
        return commonModule.isServerCall() && commonModule.isServer() && !commonModule.isExternalConnection() && !commonModule.isClientOrdinaryApplication() && !commonModule.isClientManagedApplication();
    }

    protected boolean isServer(CommonModule commonModule) {
        return !commonModule.isServerCall() && commonModule.isServer() && commonModule.isExternalConnection() && this.isClientOrdinaryAppIfNeed(commonModule) && !commonModule.isClientManagedApplication();
    }

    private boolean isClientApplication(CommonModule commonModule) {
        return this.isClientOrdinaryAppIfNeed(commonModule) && commonModule.isClientManagedApplication();
    }

    private boolean isClientOrdinaryAppIfNeed(CommonModule commonModule) {
        return commonModule.isClientOrdinaryApplication() || !this.serverConfiguration.getDiagnosticsOptions().isOrdinaryAppSupport();
    }
}

