/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.regex.Pattern;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class AbstractFindMethodDiagnostic
extends AbstractVisitorDiagnostic {
    private Pattern methodPattern;

    AbstractFindMethodDiagnostic(Pattern pattern) {
        this.methodPattern = pattern;
    }

    protected boolean checkGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        return this.getMethodPattern().matcher(ctx.methodName().getText()).matches();
    }

    protected boolean checkMethodCall(BSLParser.MethodCallContext ctx) {
        return this.getMethodPattern().matcher(ctx.methodName().getText()).matches();
    }

    protected String getMessage(BSLParserRuleContext ctx) {
        if (ctx instanceof BSLParser.GlobalMethodCallContext) {
            return this.info.getMessage(new Object[]{((BSLParser.GlobalMethodCallContext)ctx).methodName().getText()});
        }
        if (ctx instanceof BSLParser.MethodCallContext) {
            return this.info.getMessage(new Object[]{((BSLParser.MethodCallContext)ctx).methodName().getText()});
        }
        return this.info.getMessage();
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        if (this.checkGlobalMethodCall(ctx)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx.methodName(), this.getMessage((BSLParserRuleContext)ctx));
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    public ParseTree visitMethodCall(BSLParser.MethodCallContext ctx) {
        if (this.checkMethodCall(ctx)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx.methodName(), this.getMessage((BSLParserRuleContext)ctx));
        }
        return (ParseTree)super.visitMethodCall(ctx);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Pattern getMethodPattern() {
        return this.methodPattern;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMethodPattern(Pattern methodPattern) {
        this.methodPattern = methodPattern;
    }
}

