/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, scope=DiagnosticScope.BSL, modules={ModuleType.CommonModule}, minutesToFix=1, tags={DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.SUSPICIOUS})
public class CommonModuleMissingAPIDiagnostic
extends AbstractDiagnostic {
    private static final Set<String> REGION_NAME = CommonModuleMissingAPIDiagnostic.makeRegionsAPI();

    private static Set<String> makeRegionsAPI() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.add("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        result.add("Public");
        result.add("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441");
        result.add("Internal");
        return result;
    }

    protected void check() {
        SymbolTree symbolTree = this.documentContext.getSymbolTree();
        List moduleMethods = symbolTree.getMethods();
        if (moduleMethods.isEmpty()) {
            return;
        }
        Range range = symbolTree.getModule().getSelectionRange();
        if (Ranges.isEmpty((Range)range)) {
            return;
        }
        boolean isModuleWithoutExportSub = moduleMethods.stream().noneMatch(MethodSymbol::isExport);
        boolean isModuleWithoutRegionAPI = symbolTree.getModuleLevelRegions().stream().map(RegionSymbol::getName).noneMatch(REGION_NAME::contains);
        if (isModuleWithoutExportSub || isModuleWithoutRegionAPI) {
            this.diagnosticStorage.addDiagnostic(range);
        }
    }
}

