/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE})
public class ConsecutiveEmptyLinesDiagnostic
extends AbstractDiagnostic
implements QuickFixProvider {
    private static final int DEFAULT_ALLOWED_EMPTY_LINES_COUNT = 1;
    @DiagnosticParameter(type=Integer.class, defaultValue="1")
    private int allowedEmptyLinesCount = 1;

    protected void check() {
        List tokens = this.documentContext.getTokens();
        if (tokens.isEmpty()) {
            return;
        }
        int[] prevLineStorage = new int[]{0};
        tokens.subList(0, tokens.size() - 1).stream().filter(token -> token.getType() != 2).mapToInt(Token::getLine).distinct().forEachOrdered(currentLine -> {
            this.checkEmptyLines(currentLine - 1, prevLineStorage[0]);
            prevLineStorage[0] = currentLine;
        });
        this.checkEmptyLines(ConsecutiveEmptyLinesDiagnostic.getEofTokenLine((List)tokens), prevLineStorage[0]);
    }

    private void checkEmptyLines(int currentLine, int previousLine) {
        if (currentLine - previousLine > this.allowedEmptyLinesCount) {
            this.addIssue(previousLine, currentLine);
        }
    }

    private static int getEofTokenLine(List<Token> tokens) {
        return tokens.get(tokens.size() - 1).getLine();
    }

    private void addIssue(int startEmptyLine, int lastEmptyLine) {
        this.diagnosticStorage.addDiagnostic(startEmptyLine, 0, lastEmptyLine - 1, 0);
    }

    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        int eofTokenLine = ConsecutiveEmptyLinesDiagnostic.getEofTokenLine((List)documentContext.getTokens());
        List textEdits = diagnostics.stream().map(diagnostic -> ConsecutiveEmptyLinesDiagnostic.getQuickFixText((Diagnostic)diagnostic, (int)eofTokenLine)).collect(Collectors.toList());
        return CodeActionProvider.createCodeActions(textEdits, (String)this.info.getResourceString("quickFixMessage"), (URI)documentContext.getUri(), diagnostics);
    }

    private static TextEdit getQuickFixText(Diagnostic diagnostic, int eofTokenLine) {
        Range range = diagnostic.getRange();
        int endLine = range.getEnd().getLine() + 1;
        String newText = "\n";
        if (endLine == eofTokenLine) {
            --endLine;
            newText = "";
        }
        Range newRange = Ranges.create((int)range.getStart().getLine(), (int)0, (int)endLine, (int)0);
        return new TextEdit(newRange, newText);
    }
}

