/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.CreateQueryInCycleDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.bsl.Constructors;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=20, tags={DiagnosticTag.PERFORMANCE})
public class CreateQueryInCycleDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern EXECUTE_CALL_PATTERN = CaseInsensitivePattern.compile((String)"\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c|Execute");
    private static final Pattern QUERY_BUILDER_PATTERN = CaseInsensitivePattern.compile((String)"\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c\u0417\u0430\u043f\u0440\u043e\u0441\u0430|QueryBuilder");
    private static final Pattern REPORT_BUILDER_PATTERN = CaseInsensitivePattern.compile((String)"\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c\u041e\u0442\u0447\u0435\u0442\u0430|ReportBuilder");
    private static final Pattern QUERY_PATTERN = CaseInsensitivePattern.compile((String)"\u0417\u0430\u043f\u0440\u043e\u0441|Query");
    private static final String BOOLEAN_TYPE = "Boolean";
    private static final String DATE_TYPE = "Datetime";
    private static final String NULL_TYPE = "Null";
    private static final String NUMBER_TYPE = "Number";
    private static final String REPORT_BUILDER_TYPE = "ReportBuilder";
    private static final String STRING_TYPE = "String";
    private static final String QUERY_BUILDER_TYPE = "QueryBuilder";
    private static final String QUERY_TYPE = "Query";
    private static final String UNDEFINED_TYPE = "Undefined";
    private static final String GLOBAL_SCOPE = "GLOBAL_SCOPE";
    private static final String MODULE_SCOPE = "MODULE_SCOPE";
    private VariableScope currentScope;

    private static String getTypeFromConstValue(BSLParser.ConstValueContext constValue) {
        String result = constValue.string() != null ? "String" : (constValue.DATETIME() != null ? "Datetime" : (constValue.numeric() != null ? "Number" : (constValue.TRUE() != null ? "Boolean" : (constValue.FALSE() != null ? "Boolean" : (constValue.NULL() != null ? "Null" : "Undefined")))));
        return result;
    }

    private static String getTypeFromNewExpressionContext(BSLParser.NewExpressionContext newExpression) {
        String typeName = Constructors.typeName((BSLParser.NewExpressionContext)newExpression).orElse("Undefined");
        if (QUERY_BUILDER_PATTERN.matcher(typeName).matches()) {
            return "QueryBuilder";
        }
        if (REPORT_BUILDER_PATTERN.matcher(typeName).matches()) {
            return "ReportBuilder";
        }
        if (QUERY_PATTERN.matcher(typeName).matches()) {
            return "Query";
        }
        return typeName;
    }

    private static String getVariableNameFromCallStatementContext(BSLParser.CallStatementContext callStatement) {
        return callStatement.IDENTIFIER().getText();
    }

    private static String getVariableNameFromModifierContext(BSLParser.ModifierContext modifier) {
        BSLParserRuleContext parent = modifier.getParent();
        if (parent instanceof BSLParser.ComplexIdentifierContext) {
            return CreateQueryInCycleDiagnostic.getComplexPathName((BSLParser.ComplexIdentifierContext)((BSLParser.ComplexIdentifierContext)parent), (BSLParser.ModifierContext)modifier);
        }
        if (parent instanceof BSLParser.CallStatementContext) {
            BSLParser.CallStatementContext parentCall = (BSLParser.CallStatementContext)parent;
            return parentCall.modifier().stream().takeWhile(e -> !e.equals(modifier)).map(RuleContext::getText).collect(Collectors.joining("", parentCall.IDENTIFIER().getText(), ""));
        }
        return null;
    }

    private static String getComplexPathName(BSLParser.ComplexIdentifierContext ci, @Nullable BSLParser.ModifierContext to) {
        return ci.modifier().stream().takeWhile(e -> !e.equals(to)).map(RuleContext::getText).collect(Collectors.joining("", ci.getChild(0).getText(), ""));
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        this.currentScope = new VariableScope();
        this.currentScope.enterScope("GLOBAL_SCOPE");
        ParseTree result = (ParseTree)super.visitFile(ctx);
        this.currentScope = null;
        return result;
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.currentScope.enterScope("MODULE_SCOPE");
        ParseTree result = (ParseTree)super.visitFileCodeBlock(ctx);
        this.currentScope.leaveScope();
        return result;
    }

    public ParseTree visitProcedure(BSLParser.ProcedureContext ctx) {
        this.currentScope.enterScope(ctx.procDeclaration().subName().getText());
        ParseTree result = (ParseTree)super.visitProcedure(ctx);
        this.currentScope.leaveScope();
        return result;
    }

    public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
        this.currentScope.enterScope(ctx.funcDeclaration().subName().getText());
        ParseTree result = (ParseTree)super.visitFunction(ctx);
        this.currentScope.leaveScope();
        return result;
    }

    public ParseTree visitAssignment(BSLParser.AssignmentContext ctx) {
        if (ctx.expression() == null) {
            return (ParseTree)super.visitAssignment(ctx);
        }
        BSLParser.MemberContext firstMember = ctx.expression().member(0);
        if (firstMember == null) {
            return (ParseTree)super.visitAssignment(ctx);
        }
        String variableName = ctx.lValue().getText();
        VariableDefinition currentVariable = new VariableDefinition(variableName);
        currentVariable.addDeclaration((ParseTree)ctx.lValue());
        if (firstMember.complexIdentifier() != null) {
            currentVariable.types.addAll(this.getTypesFromComplexIdentifier(firstMember.complexIdentifier()));
        } else if (firstMember.constValue() != null) {
            currentVariable.types.add(CreateQueryInCycleDiagnostic.getTypeFromConstValue((BSLParser.ConstValueContext)firstMember.constValue()));
        } else {
            currentVariable.addType("Undefined");
        }
        this.currentScope.addVariable(currentVariable);
        return (ParseTree)super.visitAssignment(ctx);
    }

    private Set<String> getTypesFromComplexIdentifier(BSLParser.ComplexIdentifierContext complexId) {
        if (complexId.newExpression() != null) {
            return Set.of(CreateQueryInCycleDiagnostic.getTypeFromNewExpressionContext((BSLParser.NewExpressionContext)complexId.newExpression()));
        }
        if (complexId.IDENTIFIER() != null) {
            return this.currentScope.getVariableByName(CreateQueryInCycleDiagnostic.getComplexPathName((BSLParser.ComplexIdentifierContext)complexId, null)).map(variableDefinition -> variableDefinition.types).orElse(Set.of("Undefined"));
        }
        return Set.of();
    }

    private void visitDescendantCodeBlock(@Nullable BSLParser.CodeBlockContext ctx) {
        Optional.ofNullable(ctx).map(e -> e.children).stream().flatMap(Collection::stream).forEach(t -> t.accept((ParseTreeVisitor)this));
    }

    public ParseTree visitAccessCall(BSLParser.AccessCallContext ctx) {
        if (!EXECUTE_CALL_PATTERN.matcher(ctx.methodCall().methodName().getText()).matches()) {
            return (ParseTree)super.visitAccessCall(ctx);
        }
        if (!this.currentScope.codeFlowInCycle()) {
            return (ParseTree)super.visitAccessCall(ctx);
        }
        String variableName = null;
        BSLParserRuleContext errorContext = null;
        BSLParserRuleContext parent = ctx.getParent();
        if (parent instanceof BSLParser.CallStatementContext) {
            errorContext = parent;
            variableName = CreateQueryInCycleDiagnostic.getVariableNameFromCallStatementContext((BSLParser.CallStatementContext)((BSLParser.CallStatementContext)parent));
        } else if (parent instanceof BSLParser.ModifierContext) {
            BSLParser.ModifierContext callModifier = (BSLParser.ModifierContext)parent;
            errorContext = callModifier.getParent();
            variableName = CreateQueryInCycleDiagnostic.getVariableNameFromModifierContext((BSLParser.ModifierContext)callModifier);
        }
        Optional variableDefinition = this.currentScope.getVariableByName(variableName);
        BSLParserRuleContext finalErrorContext = errorContext;
        if (finalErrorContext != null) {
            variableDefinition.ifPresent(definition -> {
                if (definition.types.contains("QueryBuilder") || definition.types.contains("ReportBuilder") || definition.types.contains("Query")) {
                    this.diagnosticStorage.addDiagnostic(finalErrorContext);
                }
            });
        }
        return (ParseTree)super.visitAccessCall(ctx);
    }

    public ParseTree visitForEachStatement(BSLParser.ForEachStatementContext ctx) {
        boolean alreadyInCycle = this.currentScope.codeFlowInCycle();
        this.currentScope.flowMode.push(CodeFlowType.CYCLE);
        if (alreadyInCycle) {
            Optional.ofNullable(ctx.expression()).ifPresent(e -> e.accept((ParseTreeVisitor)this));
        }
        this.visitDescendantCodeBlock(ctx.codeBlock());
        this.currentScope.flowMode.pop();
        return ctx;
    }

    public ParseTree visitWhileStatement(BSLParser.WhileStatementContext ctx) {
        this.currentScope.flowMode.push(CodeFlowType.CYCLE);
        ParseTree result = (ParseTree)super.visitWhileStatement(ctx);
        this.currentScope.flowMode.pop();
        return result;
    }

    public ParseTree visitForStatement(BSLParser.ForStatementContext ctx) {
        boolean alreadyInCycle = this.currentScope.codeFlowInCycle();
        this.currentScope.flowMode.push(CodeFlowType.CYCLE);
        if (alreadyInCycle) {
            ctx.expression().forEach(e -> e.accept((ParseTreeVisitor)this));
        }
        this.visitDescendantCodeBlock(ctx.codeBlock());
        this.currentScope.flowMode.pop();
        return ctx;
    }
}

