/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.CRITICAL, minutesToFix=25, tags={DiagnosticTag.BRAINOVERLOAD}, extraMinForComplexity=1.0)
public class CyclomaticComplexityDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int COMPLEXITY_THRESHOLD = 20;
    private static final boolean CHECK_MODULE_BODY = true;
    @DiagnosticParameter(type=Integer.class, defaultValue="20")
    private int complexityThreshold = 20;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkModuleBody = true;
    private boolean fileCodeBlockChecked;

    private List<DiagnosticRelatedInformation> makeRelations(MethodSymbol methodSymbol) {
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        List secondaryLocations = (List)this.documentContext.getCyclomaticComplexityData().getMethodsComplexitySecondaryLocations().get(methodSymbol);
        secondaryLocations.stream().map(secondaryLocation -> RelatedInformation.create((URI)this.documentContext.getUri(), (Range)secondaryLocation.getRange(), (String)secondaryLocation.getMessage())).collect(Collectors.toCollection(() -> relatedInformation));
        return relatedInformation;
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        Optional optionalMethodSymbol = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx);
        optionalMethodSymbol.ifPresent(methodSymbol -> {
            Integer methodComplexity = (Integer)this.documentContext.getCyclomaticComplexityData().getMethodsComplexity().get(methodSymbol);
            if (methodComplexity > this.complexityThreshold) {
                this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getMessage(new Object[]{methodSymbol.getName(), methodComplexity, this.complexityThreshold}), this.makeRelations(methodSymbol));
            }
        });
        return ctx;
    }

    public ParseTree visitFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.checkFileCodeBlock((BSLParserRuleContext)ctx);
        this.fileCodeBlockChecked = ctx.getChildCount() > 0;
        return ctx;
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        if (!this.fileCodeBlockChecked) {
            this.checkFileCodeBlock((BSLParserRuleContext)ctx);
        }
        return ctx;
    }

    private void checkFileCodeBlock(BSLParserRuleContext ctx) {
        if (!this.checkModuleBody) {
            return;
        }
        Integer fileCodeBlockComplexity = this.documentContext.getCyclomaticComplexityData().getFileCodeBlockComplexity();
        if (fileCodeBlockComplexity > this.complexityThreshold) {
            ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
            relatedInformation.add(RelatedInformation.create((URI)this.documentContext.getUri(), (Range)Ranges.create((Token)ctx.getStart()), (String)this.info.getMessage(new Object[]{"body", fileCodeBlockComplexity, this.complexityThreshold})));
            List secondaryLocations = this.documentContext.getCyclomaticComplexityData().getFileBlockComplexitySecondaryLocations();
            secondaryLocations.stream().map(secondaryLocation -> RelatedInformation.create((URI)this.documentContext.getUri(), (Range)secondaryLocation.getRange(), (String)secondaryLocation.getMessage())).collect(Collectors.toCollection(() -> relatedInformation));
            this.diagnosticStorage.addDiagnostic(ctx.getStart(), this.info.getMessage(new Object[]{"body", fileCodeBlockComplexity, this.complexityThreshold}), relatedInformation);
        }
    }
}

