/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.Register;
import com.github._1c_syntax.bsl.types.MDOType;
import java.util.List;

@DiagnosticMetadata(activatedByDefault=false, type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE}, scope=DiagnosticScope.BSL, canLocateOnProject=true)
public class DenyIncompleteValuesDiagnostic
extends AbstractMetadataDiagnostic {
    public DenyIncompleteValuesDiagnostic() {
        super(List.of(MDOType.INFORMATION_REGISTER, MDOType.ACCUMULATION_REGISTER, MDOType.ACCOUNTING_REGISTER, MDOType.CALCULATION_REGISTER));
    }

    protected void checkMetadata(MD mdo) {
        if (mdo instanceof Register) {
            Register register = (Register)mdo;
            register.getDimensions().stream().filter(dimension -> !dimension.isDenyIncompleteValues()).forEach(dimension -> {
                String ownerMDOName = MdoRefBuilder.getLocaleOwnerMdoName((DocumentContext)this.documentContext, (MD)mdo);
                this.addDiagnostic(this.info.getMessage(new Object[]{dimension.getName(), ownerMDOName}));
            });
        }
    }
}

