/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.DiagnosticStorage;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, scope=DiagnosticScope.BSL, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_14, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.DEPRECATED})
public class DeprecatedTypeManagedFormDiagnostic
extends AbstractVisitorDiagnostic
implements QuickFixProvider {
    private static final Pattern paramPattern = CaseInsensitivePattern.compile((String)"\"(\u0423\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u0430\u044f\u0424\u043e\u0440\u043c\u0430|ManagedForm)\"");
    private static final Pattern methodPattern = CaseInsensitivePattern.compile((String)"(\u0422\u0438\u043f|Type)");

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        Optional.of(ctx).filter(it -> methodPattern.matcher(it.methodName().getText()).matches()).map(BSLParser.GlobalMethodCallContext::doCall).map(BSLParser.DoCallContext::callParamList).filter(callParamList -> paramPattern.matcher(callParamList.getText()).matches()).ifPresent(arg_0 -> ((DiagnosticStorage)this.diagnosticStorage).addDiagnostic(arg_0));
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList textEdits = new ArrayList();
        diagnostics.forEach(diagnostic -> {
            TextEdit textEdit = new TextEdit(diagnostic.getRange(), this.info.getResourceString("changeFix"));
            textEdits.add(textEdit);
        });
        return CodeActionProvider.createCodeActions(textEdits, (String)this.info.getResourceString("quickFixMessage"), (URI)documentContext.getUri(), diagnostics);
    }
}

