/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Trees;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE})
public class DuplicateStringLiteralDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int ALLOWED_NUMBER_COPIES = 2;
    private static final boolean ANALYZE_FILE = false;
    private static final boolean CASE_SENSITIVE = false;
    private static final int MIN_TEXT_LENGTH = 5;
    @DiagnosticParameter(type=Integer.class, defaultValue="2")
    private int allowedNumberCopies = 2;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean analyzeFile = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean caseSensitive = false;
    @DiagnosticParameter(type=Integer.class, defaultValue="5")
    private int minTextLength = 5;

    public void configure(Map<String, Object> configuration) {
        super.configure(configuration);
        if (this.allowedNumberCopies < 1) {
            this.allowedNumberCopies = 2;
        }
        this.minTextLength = Math.max(this.minTextLength, 5);
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        if (this.analyzeFile) {
            this.checkStringLiterals((BSLParserRuleContext)ctx);
            return ctx;
        }
        return (ParseTree)super.visitFile(ctx);
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        this.checkStringLiterals((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.checkStringLiterals((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.checkStringLiterals((BSLParserRuleContext)ctx);
        return ctx;
    }

    private void checkStringLiterals(BSLParserRuleContext ctx) {
        Trees.findAllRuleNodes((ParseTree)ctx, (int)79).stream().map(BSLParserRuleContext.class::cast).filter(arg_0 -> this.checkLiteral(arg_0)).collect(Collectors.groupingBy(arg_0 -> this.getLiteralText(arg_0))).forEach((name, literals) -> {
            if (literals.size() > this.allowedNumberCopies) {
                List relatedInformation = literals.stream().map(literal -> RelatedInformation.create((URI)this.documentContext.getUri(), (Range)Ranges.create((ParserRuleContext)literal), (String)literal.getText())).collect(Collectors.toList());
                BSLParserRuleContext firstLiteral = (BSLParserRuleContext)literals.get(0);
                this.diagnosticStorage.addDiagnostic(firstLiteral, this.info.getMessage(new Object[]{firstLiteral.getText()}), relatedInformation);
            }
        });
    }

    private String getLiteralText(BSLParserRuleContext literal) {
        if (this.caseSensitive) {
            return literal.getText();
        }
        return literal.getText().toLowerCase(Locale.ROOT);
    }

    private boolean checkLiteral(BSLParserRuleContext literal) {
        return literal.getText().length() >= this.minTextLength;
    }
}

