/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.DuplicatedInsertionIntoCollectionDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.eclipse.lsp4j.Range;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.SUSPICIOUS, DiagnosticTag.BADPRACTICE})
public class DuplicatedInsertionIntoCollectionDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern INSERT_ADD_METHOD_PATTERN = CaseInsensitivePattern.compile((String)"\u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c|\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c|insert|add");
    private static final Pattern INSERT_METHOD_PATTERN = CaseInsensitivePattern.compile((String)"\u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c|insert");
    private static final Pattern IGNORED_BSL_VALUES_PATTERN = CaseInsensitivePattern.compile((String)"\u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e|undefined|0|\u0441\u0438\u043c\u0432\u043e\u043b\u044b\\.[\\w\u0430-\u044f\u0451]+|chars\\.[\\w\u0430-\u044f\u0451]+");
    private static final List<Integer> BREAKERS_INDEXES = Arrays.asList(55, 45, 44, 46);
    private static final List<Integer> BREAKERS_ROOTS = Arrays.asList(53, 52, 51, 54);
    private static final int LENGTH_OF_EMPTY_STRING_WITH_QUOTES = 2;
    private static final boolean IS_ALLOWED_METHOD_ADD = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean isAllowedMethodADD = true;
    private Pattern methodPattern = INSERT_ADD_METHOD_PATTERN;
    private BSLParser.CodeBlockContext codeBlock;
    private Range blockRange;
    private List<BSLParser.AssignmentContext> blockAssignments;
    private List<BSLParserRuleContext> blockBreakers;
    private List<BSLParser.CallParamContext> blockCallParams;
    private List<String> firstParamInnerIdentifiers;

    public void configure(Map<String, Object> configuration) {
        super.configure(configuration);
        if (!this.isAllowedMethodADD) {
            this.methodPattern = INSERT_METHOD_PATTERN;
        }
    }

    public ParseTree visitCodeBlock(BSLParser.CodeBlockContext codeBlock) {
        this.codeBlock = codeBlock;
        List possibleDuplicateStatements = this.getPossibleDuplicates();
        if (!possibleDuplicateStatements.isEmpty()) {
            this.blockRange = Ranges.create((ParserRuleContext)codeBlock);
            this.explorePossibleDuplicateStatements(possibleDuplicateStatements).forEach(arg_0 -> this.fireIssue(arg_0));
        }
        this.clearCodeBlockFields();
        return (ParseTree)super.visitCodeBlock(codeBlock);
    }

    private List<GroupingData> getPossibleDuplicates() {
        return this.codeBlock.statement().stream().map(BSLParser.StatementContext::callStatement).filter(Objects::nonNull).filter(callStatement -> callStatement.accessCall() != null).map(callStatement -> this.groupingCalls(callStatement, callStatement.accessCall())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private GroupingData groupingCalls(BSLParser.CallStatementContext callStatement, BSLParser.AccessCallContext accessCallContext) {
        String parens;
        TerminalNode identifierContext;
        BSLParser.MethodCallContext methodCallContext = accessCallContext.methodCall();
        List callParams = methodCallContext.doCall().callParamList().callParam();
        BSLParser.CallParamContext firstParamContext = (BSLParser.CallParamContext)callParams.get(0);
        if (firstParamContext.getChildCount() == 0) {
            return null;
        }
        String methodName = methodCallContext.methodName().getText();
        if (!this.isAppropriateMethodCall(methodName)) {
            return null;
        }
        String firstParam = firstParamContext.getText();
        if (DuplicatedInsertionIntoCollectionDiagnostic.isBlankBSLString((String)firstParam) || DuplicatedInsertionIntoCollectionDiagnostic.isIgnoredBSLValues((String)firstParam)) {
            return null;
        }
        if (callStatement.IDENTIFIER() != null) {
            identifierContext = callStatement.IDENTIFIER();
            parens = "";
        } else {
            identifierContext = callStatement.globalMethodCall().methodName().IDENTIFIER();
            parens = "()";
        }
        String collectionName = DuplicatedInsertionIntoCollectionDiagnostic.getFullIdentifier((String)identifierContext.getText().concat(parens), (List)callStatement.modifier());
        return new GroupingData(callStatement, collectionName, collectionName.concat("."), methodName, firstParam, firstParam.concat("."), firstParamContext);
    }

    private boolean isAppropriateMethodCall(String methodName) {
        return this.methodPattern.matcher(methodName).matches();
    }

    private static boolean isBlankBSLString(String text) {
        int length = text.length();
        return length >= 2 && text.charAt(0) == '\"' && text.charAt(length - 1) == '\"' && text.substring(1, length - 1).isBlank();
    }

    private static boolean isIgnoredBSLValues(String text) {
        return IGNORED_BSL_VALUES_PATTERN.matcher(text).matches();
    }

    private Stream<List<GroupingData>> explorePossibleDuplicateStatements(List<GroupingData> statements) {
        CaseInsensitiveMap mapOfMapsByIdentifier = statements.stream().collect(Collectors.groupingBy(GroupingData::getCollectionName, CaseInsensitiveMap::new, Collectors.groupingBy(GroupingData::getMethodName, CaseInsensitiveMap::new, Collectors.groupingBy(GroupingData::getFirstParamName, CaseInsensitiveMap::new, Collectors.mapping(groupingData -> groupingData, Collectors.toList())))));
        return mapOfMapsByIdentifier.values().stream().flatMap(mapByMethod -> mapByMethod.values().stream()).flatMap(mapByFirstParam -> mapByFirstParam.values().stream()).filter(duplicates -> duplicates.size() > 1).map(arg_0 -> this.excludeValidChanges(arg_0)).filter(duplicates -> duplicates.size() > 1);
    }

    private List<GroupingData> excludeValidChanges(List<GroupingData> duplicates) {
        ArrayList<GroupingData> result = new ArrayList<GroupingData>();
        for (int i = 0; i < duplicates.size() && this.excludeValidElements(duplicates, i, result); ++i) {
        }
        this.firstParamInnerIdentifiers = null;
        return result;
    }

    private boolean excludeValidElements(List<GroupingData> duplicates, int currIndex, List<GroupingData> listForIssue) {
        GroupingData next;
        if (duplicates.size() - currIndex <= 1) {
            return false;
        }
        GroupingData first = duplicates.get(currIndex);
        boolean alreadyAdd = !listForIssue.isEmpty() && listForIssue.get(listForIssue.size() - 1) == first;
        for (int i = currIndex + 1; i < duplicates.size() && !this.hasValidChange(first, next = duplicates.get(i)); ++i) {
            if (!alreadyAdd) {
                alreadyAdd = true;
                listForIssue.add(first);
            }
            listForIssue.add(next);
        }
        return true;
    }

    private boolean hasValidChange(GroupingData first, GroupingData next) {
        Range border = Ranges.create((Token)first.callStatement.getStop(), (Token)next.callStatement.getStart());
        return this.hasAssignBetweenCalls(first, border) || this.hasBreakersBetweenCalls(border) || this.usedAsFunctionParamsBetweenCalls(border, first);
    }

    private boolean hasAssignBetweenCalls(GroupingData groupingData, Range border) {
        return this.getAssignments().stream().filter(assignmentContext -> Ranges.containsRange((Range)border, (Range)Ranges.create((ParserRuleContext)assignmentContext))).map(assignmentContext -> assignmentContext.lValue().getText()).anyMatch(assignText -> this.usedIdentifiers(assignText, groupingData));
    }

    private boolean usedIdentifiers(String expression, GroupingData groupingData) {
        String expressionWithDot = expression.concat(".");
        if (DuplicatedInsertionIntoCollectionDiagnostic.startWithIgnoreCase((String)groupingData.collectionNameWithDot, (String)expressionWithDot)) {
            return true;
        }
        return this.getAllInnerIdentifiersWithDot(groupingData.firstParamContext).stream().anyMatch(identifierWithDot -> DuplicatedInsertionIntoCollectionDiagnostic.startWithIgnoreCase((String)identifierWithDot, (String)expressionWithDot) || DuplicatedInsertionIntoCollectionDiagnostic.startWithIgnoreCase((String)expressionWithDot, (String)identifierWithDot));
    }

    private static boolean startWithIgnoreCase(String identifier, String textWithDot) {
        return identifier.length() >= textWithDot.length() && identifier.substring(0, textWithDot.length()).equalsIgnoreCase(textWithDot);
    }

    private boolean hasBreakersBetweenCalls(Range border) {
        return this.getBreakers().stream().filter(bslParserRuleContext -> Ranges.containsRange((Range)border, (Range)Ranges.create((ParserRuleContext)bslParserRuleContext))).anyMatch(arg_0 -> this.hasBreakerIntoCodeBlock(arg_0));
    }

    private boolean hasBreakerIntoCodeBlock(BSLParserRuleContext breakerContext) {
        if (breakerContext.getRuleIndex() == 55) {
            return true;
        }
        BSLParserRuleContext rootParent = Trees.getRootParent((BSLParserRuleContext)breakerContext, (Collection)BREAKERS_ROOTS);
        if (rootParent == null) {
            return true;
        }
        return !Ranges.containsRange((Range)this.blockRange, (Range)Ranges.create((ParserRuleContext)rootParent));
    }

    private boolean usedAsFunctionParamsBetweenCalls(Range border, GroupingData groupingData) {
        return this.getCallParams().stream().filter(callParamContext -> Ranges.containsRange((Range)border, (Range)Ranges.create((ParserRuleContext)callParamContext))).anyMatch(callParamContext -> this.usedAsFunctionParams(callParamContext, groupingData));
    }

    private boolean usedAsFunctionParams(BSLParser.CallParamContext callParamContext, GroupingData groupingData) {
        return Optional.of(callParamContext).map(BSLParser.CallParamContext::expression).map(BSLParser.ExpressionContext::member).filter(memberContexts -> this.usedIdentifiers(memberContexts, groupingData)).isPresent();
    }

    private boolean usedIdentifiers(List<? extends BSLParser.MemberContext> memberContexts, GroupingData groupingData) {
        return memberContexts.stream().map(BSLParser.MemberContext::complexIdentifier).filter(Objects::nonNull).filter(complexIdentifierContext -> complexIdentifierContext.IDENTIFIER() != null).map(BSLParserRuleContext::getText).anyMatch(identifier -> this.usedIdentifiers(identifier, groupingData));
    }

    private void fireIssue(List<GroupingData> duplicates) {
        GroupingData dataForIssue = duplicates.get(1);
        List relatedInformationList = duplicates.stream().map(GroupingData::getCallStatement).map(context -> RelatedInformation.create((URI)this.documentContext.getUri(), (Range)Ranges.create((ParserRuleContext)context), (String)"+1")).collect(Collectors.toList());
        String message = this.info.getMessage(new Object[]{dataForIssue.firstParamName, dataForIssue.collectionName});
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)dataForIssue.callStatement, message, relatedInformationList);
    }

    private List<BSLParser.AssignmentContext> getAssignments() {
        if (this.blockAssignments == null) {
            this.blockAssignments = Trees.findAllRuleNodes((ParseTree)this.codeBlock, (int)81).stream().map(BSLParser.AssignmentContext.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return this.blockAssignments;
    }

    private List<BSLParserRuleContext> getBreakers() {
        if (this.blockBreakers == null) {
            this.blockBreakers = Trees.findAllRuleNodes((ParseTree)this.codeBlock, (Collection)BREAKERS_INDEXES).stream().map(BSLParserRuleContext.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return this.blockBreakers;
    }

    private List<BSLParser.CallParamContext> getCallParams() {
        if (this.blockCallParams == null) {
            this.blockCallParams = Trees.findAllRuleNodes((ParseTree)this.codeBlock, (int)83).stream().map(BSLParser.CallParamContext.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return this.blockCallParams;
    }

    private List<String> getAllInnerIdentifiersWithDot(BSLParser.CallParamContext param) {
        if (this.firstParamInnerIdentifiers == null) {
            List identifiers = Trees.findAllRuleNodes((ParseTree)param, (int)95).stream().map(BSLParser.ComplexIdentifierContext.class::cast).filter(complexIdentifierContext -> complexIdentifierContext.IDENTIFIER() != null).collect(Collectors.toList());
            ArrayList<String> reducedIdentifiers = new ArrayList<String>();
            for (BSLParser.ComplexIdentifierContext identifier : identifiers) {
                List modifiers = identifier.modifier();
                String firstIdentifier = identifier.IDENTIFIER().getText();
                String fullIdentifier = DuplicatedInsertionIntoCollectionDiagnostic.getFullIdentifier((String)firstIdentifier, (List)modifiers);
                reducedIdentifiers.add(fullIdentifier);
                String reducedIdentifier = firstIdentifier;
                for (BSLParser.ModifierContext modifier : modifiers) {
                    String modfifier = modifier.getText();
                    reducedIdentifier = reducedIdentifier.concat(".").concat(modfifier);
                    reducedIdentifiers.add(reducedIdentifier);
                }
            }
            this.firstParamInnerIdentifiers = reducedIdentifiers;
        }
        return this.firstParamInnerIdentifiers;
    }

    private void clearCodeBlockFields() {
        this.codeBlock = null;
        this.blockRange = null;
        this.blockAssignments = null;
        this.blockBreakers = null;
        this.blockCallParams = null;
    }

    private static String getFullIdentifier(String firstIdentifier, List<? extends BSLParser.ModifierContext> modifiers) {
        return modifiers.stream().map(BSLParserRuleContext::getText).reduce(firstIdentifier, (x, y) -> x.concat(".").concat((String)y)).replace("..", ".");
    }
}

