/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractListenerDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.parser.BSLParser;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.STANDARD})
public class EmptyRegionDiagnostic
extends AbstractListenerDiagnostic
implements QuickFixProvider {
    private int currentRegionLevel;
    private int currentUsageLevel;
    private final Deque<BSLParser.RegionStartContext> regions = new ArrayDeque();

    public void enterEveryRule(ParserRuleContext ctx) {
        if (ctx instanceof BSLParser.RegionStartContext) {
            ++this.currentRegionLevel;
            this.regions.push((BSLParser.RegionStartContext)ctx);
        } else if (!(ctx instanceof BSLParser.PreprocessorContext || ctx instanceof BSLParser.RegionNameContext || ctx instanceof BSLParser.RegionEndContext || ctx instanceof BSLParser.StatementContext || this.currentUsageLevel >= this.currentRegionLevel)) {
            this.currentUsageLevel = this.currentRegionLevel;
        }
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        if (ctx instanceof BSLParser.RegionEndContext && !this.regions.isEmpty()) {
            BSLParser.RegionStartContext currentRegion = (BSLParser.RegionStartContext)this.regions.pop();
            if (this.currentUsageLevel < this.currentRegionLevel) {
                this.diagnosticStorage.addDiagnostic(Ranges.create((ParserRuleContext)currentRegion.getParent(), (ParserRuleContext)ctx), this.info.getMessage(new Object[]{currentRegion.regionName().getText()}));
            } else if (this.currentRegionLevel == this.currentUsageLevel) {
                --this.currentUsageLevel;
            }
            --this.currentRegionLevel;
        }
    }

    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList textEdits = new ArrayList(diagnostics.size());
        diagnostics.stream().map(Diagnostic::getRange).sorted(Comparator.comparingInt(o -> o.getStart().getLine())).reduce((prev, curr) -> {
            if (prev.getEnd().getLine() > curr.getStart().getLine()) {
                return prev;
            }
            textEdits.add(new TextEdit(prev, ""));
            return curr;
        }).ifPresent(lastRange -> textEdits.add(new TextEdit(lastRange, "")));
        return CodeActionProvider.createCodeActions(textEdits, (String)this.info.getResourceString("quickFixMessage"), (URI)documentContext.getUri(), diagnostics);
    }
}

