/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=1, modules={ModuleType.FormModule, ModuleType.ObjectModule, ModuleType.RecordSetModule, ModuleType.CommonModule}, tags={DiagnosticTag.STANDARD, DiagnosticTag.DEPRECATED})
public class ExcessiveAutoTestCheckDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern ERROR_EXPRESSION = CaseInsensitivePattern.compile((String)"(\\.\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e\\(\"\u0410\u0432\u0442\u043e\u0422\u0435\u0441\u0442\"\\)|=\"\u0410\u0432\u0442\u043e\u0422\u0435\u0441\u0442\"|\\.Property\\(\"AutoTest\"\\)|=\"AutoTest\")$");

    public ParseTree visitIfBranch(BSLParser.IfBranchContext ctx) {
        if (ExcessiveAutoTestCheckDiagnostic.expressionMatchesPattern((BSLParser.ExpressionContext)ctx.expression()) && ExcessiveAutoTestCheckDiagnostic.codeBlockWithOnlyReturn((BSLParser.CodeBlockContext)ctx.codeBlock())) {
            this.diagnosticStorage.addDiagnostic(ctx.getParent());
            return ctx;
        }
        return (ParseTree)super.visitIfBranch(ctx);
    }

    private static boolean expressionMatchesPattern(BSLParser.ExpressionContext expression) {
        return ERROR_EXPRESSION.matcher(expression.getText()).find();
    }

    private static boolean codeBlockWithOnlyReturn(BSLParser.CodeBlockContext codeBlock) {
        BSLParser.CompoundStatementContext compoundStatement;
        List statements = codeBlock.statement();
        if (statements.size() == 1 && (compoundStatement = ((BSLParser.StatementContext)statements.get(0)).compoundStatement()) != null) {
            return compoundStatement.returnStatement() != null;
        }
        return false;
    }
}

