/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.DESIGN, DiagnosticTag.BADPRACTICE})
public class FunctionReturnsSamePrimitiveDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String KEY_MESSAGE = "diagnosticMessageReturnStatement";
    private static final Pattern pattern = CaseInsensitivePattern.compile((String)"^(\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0439|attachable)_");
    private static final boolean SKIP_ATTACHABLE = true;
    private static final boolean CASE_SENSITIVE_FOR_STRING = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean skipAttachable = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean caseSensitiveForString = false;

    public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
        boolean abortCheck;
        if (this.skipAttachable && (abortCheck = Optional.ofNullable(ctx.funcDeclaration()).map(BSLParser.FuncDeclarationContext::subName).filter(subNameContext -> pattern.matcher(subNameContext.getText()).find()).isPresent())) {
            return ctx;
        }
        Collection tree = Trees.findAllRuleNodes((ParseTree)ctx, (int)55);
        if (tree.size() > 1) {
            List expressions = tree.stream().map(BSLParser.ReturnStatementContext.class::cast).map(BSLParser.ReturnStatementContext::expression).flatMap(Stream::ofNullable).collect(Collectors.toList());
            expressions.stream().map(expression -> Trees.findAllRuleNodes((ParseTree)expression, (int)95)).filter(Collection::isEmpty).findAny().ifPresent(parseTrees -> this.checkPrimitiveValue(ctx, tree, expressions));
        }
        return ctx;
    }

    private void checkPrimitiveValue(BSLParser.FunctionContext ctx, Collection<ParseTree> tree, List<BSLParser.ExpressionContext> expressions) {
        long count = expressions.stream().map(arg_0 -> this.getExpressionText(arg_0)).distinct().count();
        if (count == 1L) {
            List relatedInformation = tree.stream().map(BSLParser.ReturnStatementContext.class::cast).map(statement -> RelatedInformation.create((URI)this.documentContext.getUri(), (Range)Ranges.create((Token)statement.getStart()), (String)this.info.getResourceString(KEY_MESSAGE))).collect(Collectors.toList());
            this.diagnosticStorage.addDiagnostic(this.getSubNameRange((BSLParserRuleContext)ctx), relatedInformation);
        }
    }

    private String getExpressionText(BSLParser.ExpressionContext expression) {
        if (this.caseSensitiveForString && Trees.nodeContains((ParseTree)expression, (Integer[])new Integer[]{79})) {
            return expression.getText();
        }
        return expression.getText().toUpperCase(Locale.ENGLISH);
    }

    private Range getSubNameRange(BSLParserRuleContext ctx) {
        return Optional.ofNullable(Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, (int)38)).map(BSLParser.SubContext.class::cast).flatMap(context -> this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)context)).map(MethodSymbol::getSubNameRange).orElse(Ranges.create((Token)ctx.getStart()));
    }
}

