/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.IdenticalExpressionsDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.FormatProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.AbstractCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslExpression;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslOperator;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ExpressionNodeType;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ExpressionParseTreeRewriter;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.NodeEqualityComparer;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TernaryOperatorNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TransitiveOperationsIgnoringComparer;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.UnaryOperationNode;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.FormattingOptions;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.SUSPICIOUS})
public class IdenticalExpressionsDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int MIN_EXPRESSION_SIZE = 3;
    private static final String POPULAR_DIVISORS_DEFAULT_VALUE = "60, 1024";
    @DiagnosticParameter(type=String.class, defaultValue="60, 1024")
    private Set<String> popularDivisors = IdenticalExpressionsDiagnostic.parseCommaSeparatedSet((String)"60, 1024");
    private final FormatProvider formatProvider;

    private static Set<String> parseCommaSeparatedSet(String values) {
        if (values.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(values.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public void configure(Map<String, Object> configuration) {
        String popularDivisorsValue = (String)configuration.getOrDefault("popularDivisors", "60, 1024");
        this.popularDivisors = IdenticalExpressionsDiagnostic.parseCommaSeparatedSet((String)popularDivisorsValue);
    }

    public ParseTree visitExpression(BSLParser.ExpressionContext ctx) {
        if (IdenticalExpressionsDiagnostic.sufficientSize((BSLParser.ExpressionContext)ctx)) {
            return ctx;
        }
        BslExpression tree = ExpressionParseTreeRewriter.buildExpressionTree((BSLParser.ExpressionContext)ctx);
        List binariesList = IdenticalExpressionsDiagnostic.flattenBinaryOperations((BslExpression)tree);
        if (binariesList.isEmpty()) {
            return ctx;
        }
        TransitiveOperationsIgnoringComparer comparer = new TransitiveOperationsIgnoringComparer();
        comparer.logicalOperationsAsTransitive(true);
        binariesList.stream().filter(x -> this.checkEquality((NodeEqualityComparer)comparer, x)).forEach(x -> this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(new Object[]{x.getRepresentingAst().getText(), this.getOperandText(x)})));
        return ctx;
    }

    private boolean checkEquality(NodeEqualityComparer comparer, BinaryOperationNode node) {
        boolean justEqual = comparer.areEqual(node.getLeft(), node.getRight());
        if (justEqual) {
            return !this.isPopularQuantification(node);
        }
        if (IdenticalExpressionsDiagnostic.isComplementary((BinaryOperationNode)node)) {
            BslExpression searchableLeft = node.getLeft();
            BinaryOperationNode complementaryNode = (BinaryOperationNode)node.getRight().cast();
            while (true) {
                boolean equal;
                boolean bl = equal = comparer.areEqual(searchableLeft, complementaryNode.getLeft()) || comparer.areEqual(searchableLeft, complementaryNode.getRight());
                if (equal) {
                    return true;
                }
                if (!IdenticalExpressionsDiagnostic.isComplementary((BinaryOperationNode)complementaryNode)) break;
                complementaryNode = (BinaryOperationNode)complementaryNode.getRight().cast();
            }
        }
        return false;
    }

    private boolean isPopularQuantification(BinaryOperationNode node) {
        BSLParser.ConstValueContext leftAst;
        BSLParser.NumericContext number;
        if (this.popularDivisors.isEmpty()) {
            return false;
        }
        if (node.getOperator() == BslOperator.DIVIDE && node.getLeft().getNodeType() == ExpressionNodeType.LITERAL && (number = (leftAst = (BSLParser.ConstValueContext)node.getLeft().getRepresentingAst()).numeric()) != null) {
            String text = number.getText();
            return this.popularDivisors.contains(text);
        }
        return false;
    }

    private String getOperandText(BinaryOperationNode node) {
        assert (node.getRepresentingAst() != null);
        BslExpression pairedOperand = node.getLeft();
        ArrayList tokens = new ArrayList();
        IdenticalExpressionsDiagnostic.fillTokens((BslExpression)pairedOperand, tokens);
        return this.formatProvider.getNewText(tokens, this.documentContext.getScriptVariantLocale(), Ranges.create(), 0, new FormattingOptions()).trim();
    }

    private static List<Token> collectTokensForUnaryOperation(UnaryOperationNode unary, List<Token> tokens) {
        tokens.addAll(Trees.getTokens((ParseTree)unary.getRepresentingAst()));
        IdenticalExpressionsDiagnostic.fillTokens((BslExpression)unary.getOperand(), tokens);
        return tokens;
    }

    private static List<Token> collectTokensForBinaryOperation(BinaryOperationNode binary, List<Token> tokens) {
        IdenticalExpressionsDiagnostic.fillTokens((BslExpression)binary.getLeft(), tokens);
        tokens.addAll(Trees.getTokens((ParseTree)binary.getRepresentingAst()));
        IdenticalExpressionsDiagnostic.fillTokens((BslExpression)binary.getRight(), tokens);
        return tokens;
    }

    private static void fillTokens(BslExpression node, List<Token> collection) {
        if (node instanceof BinaryOperationNode) {
            IdenticalExpressionsDiagnostic.collectTokensForBinaryOperation((BinaryOperationNode)((BinaryOperationNode)node.cast()), collection);
        } else if (node instanceof UnaryOperationNode) {
            IdenticalExpressionsDiagnostic.collectTokensForUnaryOperation((UnaryOperationNode)((UnaryOperationNode)node.cast()), collection);
        } else {
            collection.addAll(Trees.getTokens((ParseTree)node.getRepresentingAst()));
        }
    }

    private static List<BinaryOperationNode> flattenBinaryOperations(BslExpression tree) {
        ArrayList<BinaryOperationNode> list = new ArrayList<BinaryOperationNode>();
        IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)tree);
        return list;
    }

    private static void gatherBinaryOperations(List<BinaryOperationNode> list, BslExpression tree) {
        switch (1.$SwitchMap$com$github$_1c_syntax$bsl$languageserver$utils$expressiontree$ExpressionNodeType[tree.getNodeType().ordinal()]) {
            case 1: {
                for (BslExpression expr : ((AbstractCallNode)tree.cast()).arguments()) {
                    IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)expr);
                }
                break;
            }
            case 2: {
                IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)((UnaryOperationNode)tree.cast()).getOperand());
                break;
            }
            case 3: {
                TernaryOperatorNode ternary = (TernaryOperatorNode)tree;
                IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)ternary.getCondition());
                IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)ternary.getTruePart());
                IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)ternary.getFalsePart());
                break;
            }
            case 4: {
                BinaryOperationNode binary = (BinaryOperationNode)tree;
                BslOperator operator = binary.getOperator();
                if (operator == BslOperator.DEREFERENCE || operator == BslOperator.INDEX_ACCESS) {
                    return;
                }
                if (operator != BslOperator.ADD && operator != BslOperator.MULTIPLY) {
                    list.add(binary);
                }
                IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)binary.getLeft());
                IdenticalExpressionsDiagnostic.gatherBinaryOperations(list, (BslExpression)binary.getRight());
                break;
            }
        }
    }

    private static boolean isComplementary(BinaryOperationNode binary) {
        BslOperator operator = binary.getOperator();
        if ((operator == BslOperator.OR || operator == BslOperator.AND) && binary.getRight() instanceof BinaryOperationNode) {
            return ((BinaryOperationNode)binary.getRight()).getOperator() == operator;
        }
        return false;
    }

    private static boolean sufficientSize(BSLParser.ExpressionContext ctx) {
        return ctx.children.size() < 3;
    }

    @ConstructorProperties(value={"formatProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IdenticalExpressionsDiagnostic(FormatProvider formatProvider) {
        this.formatProvider = formatProvider;
    }
}

