/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE})
public class MagicNumberDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String DEFAULT_AUTHORIZED_NUMBERS = "-1,0,1";
    private static final boolean DEFAULT_ALLOW_MAGIC_NUMBER = true;
    @DiagnosticParameter(type=String.class, defaultValue="-1,0,1")
    private final List<String> authorizedNumbers = new ArrayList<String>(Arrays.asList("-1,0,1".split(",")));
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean allowMagicIndexes = true;

    public void configure(Map<String, Object> configuration) {
        DiagnosticHelper.configureDiagnostic((BSLDiagnostic)this, configuration, (String[])new String[]{"allowMagicIndexes"});
        this.authorizedNumbers.clear();
        String authorizedNumbersString = (String)configuration.getOrDefault("authorizedNumbers", "-1,0,1");
        for (String s : authorizedNumbersString.split(",")) {
            this.authorizedNumbers.add(s.trim());
        }
    }

    private static Optional<BSLParser.ExpressionContext> getExpression(BSLParserRuleContext ctx) {
        return Optional.of(ctx).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).filter(context -> context.getChildCount() == 1).map(BSLParserRuleContext::getParent).filter(BSLParser.ExpressionContext.class::isInstance).map(BSLParser.ExpressionContext.class::cast);
    }

    private static boolean isNumericExpression(BSLParser.ExpressionContext expression) {
        return expression.getChildCount() <= 1;
    }

    private static boolean insideCallParam(BSLParser.ExpressionContext expression) {
        return expression.getParent() instanceof BSLParser.CallParamContext;
    }

    public ParseTree visitNumeric(BSLParser.NumericContext ctx) {
        BSLParserRuleContext parent;
        String checked = ctx.getText();
        if (checked != null && this.isAllowed(checked) && ((parent = ctx.getParent()).getParent() instanceof BSLParser.DefaultValueContext || this.isWrongExpression(parent))) {
            this.diagnosticStorage.addDiagnostic(ctx.stop, this.info.getMessage(new Object[]{checked}));
        }
        return (ParseTree)this.defaultResult();
    }

    private boolean isAllowed(String s) {
        for (String elem : this.authorizedNumbers) {
            if (s.compareTo(elem) != 0) continue;
            return false;
        }
        return true;
    }

    private boolean isWrongExpression(BSLParserRuleContext numericContextParent) {
        return MagicNumberDiagnostic.getExpression((BSLParserRuleContext)numericContextParent).filter(expression -> !MagicNumberDiagnostic.isNumericExpression((BSLParser.ExpressionContext)expression) || this.mayBeNumberAccess(expression) || MagicNumberDiagnostic.insideCallParam((BSLParser.ExpressionContext)expression)).isPresent();
    }

    private boolean mayBeNumberAccess(BSLParser.ExpressionContext expression) {
        return !this.allowMagicIndexes && expression.getParent() instanceof BSLParser.AccessIndexContext;
    }
}

