/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.util.List;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, scope=DiagnosticScope.BSL, tags={DiagnosticTag.STANDARD}, canLocateOnProject=true)
public class MetadataObjectNameLengthDiagnostic
extends AbstractMetadataDiagnostic {
    private static final int MAX_METADATA_OBJECT_NAME_LENGTH = 80;
    private final LanguageServerConfiguration serverConfiguration;
    @DiagnosticParameter(type=Integer.class, defaultValue="80")
    private int maxMetadataObjectNameLength = 80;

    MetadataObjectNameLengthDiagnostic(LanguageServerConfiguration serverConfiguration) {
        super(List.of(MDOType.values()));
        this.serverConfiguration = serverConfiguration;
    }

    protected void checkMetadata(MD mdo) {
        if (mdo.getName().length() > this.maxMetadataObjectNameLength) {
            this.addAttributeDiagnostic(mdo);
        }
    }

    protected void check() {
        if (this.documentContext.getModuleType() == ModuleType.CommandModule || this.documentContext.getModuleType() == ModuleType.FormModule) {
            if (this.computeDiagnosticRange()) {
                this.documentContext.getMdObject().ifPresent(arg_0 -> this.checkMetadata(arg_0));
            }
        } else {
            super.check();
        }
    }

    private void addAttributeDiagnostic(MD attribute) {
        String mdoRef = this.serverConfiguration.getLanguage() == Language.RU ? attribute.getMdoReference().getMdoRefRu() : attribute.getMdoReference().getMdoRef();
        this.addDiagnostic(this.info.getMessage(new Object[]{mdoRef, this.maxMetadataObjectNameLength}));
    }
}

