/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.MissingCommonModuleMethodDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.model.Location;
import com.github._1c_syntax.bsl.languageserver.references.model.LocationRepository;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.languageserver.references.model.Symbol;
import com.github._1c_syntax.bsl.languageserver.references.model.SymbolOccurrence;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.ERROR})
public class MissingCommonModuleMethodDiagnostic
extends AbstractDiagnostic {
    public static final String PRIVATE_METHOD_MESSAGE = "privateMethod";
    private final LocationRepository locationRepository;

    private static String getMethodNameByLocation(BSLParserRuleContext node, Range range) {
        return Trees.findTerminalNodeContainsPosition((BSLParserRuleContext)node, (Position)range.getEnd()).map(ParseTree::getText).orElseThrow();
    }

    protected void check() {
        if (this.documentContext.getServerContext().getConfiguration().getConfigurationSource() == ConfigurationSource.EMPTY) {
            return;
        }
        this.locationRepository.getSymbolOccurrencesByLocationUri(this.documentContext.getUri()).filter(symbolOccurrence -> symbolOccurrence.getOccurrenceType() == OccurrenceType.REFERENCE).filter(symbolOccurrence -> symbolOccurrence.getSymbol().getSymbolKind() == SymbolKind.Method).filter(symbolOccurrence -> symbolOccurrence.getSymbol().getModuleType() == ModuleType.CommonModule).map(arg_0 -> this.getReferenceToMethodCall(arg_0)).flatMap(Optional::stream).forEach(arg_0 -> this.fireIssue(arg_0));
    }

    private Optional<CallData> getReferenceToMethodCall(SymbolOccurrence symbolOccurrence) {
        Symbol symbol = symbolOccurrence.getSymbol();
        Optional document = this.documentContext.getServerContext().getDocument(symbol.getMdoRef(), symbol.getModuleType());
        if (document.isEmpty()) {
            return Optional.empty();
        }
        Optional mdObject = ((DocumentContext)document.get()).getMdObject();
        if (mdObject.isEmpty()) {
            return Optional.empty();
        }
        Optional methodSymbol = ((DocumentContext)document.get()).getSymbolTree().getMethodSymbol(symbol.getSymbolName());
        if (methodSymbol.isEmpty()) {
            Location location = symbolOccurrence.getLocation();
            return Optional.of(new CallData(((MD)mdObject.get()).getName(), MissingCommonModuleMethodDiagnostic.getMethodNameByLocation((BSLParserRuleContext)this.documentContext.getAst(), (Range)location.getRange()), location.getRange(), false, false));
        }
        if (((DocumentContext)document.get()).getUri().equals(this.documentContext.getUri())) {
            return Optional.empty();
        }
        return methodSymbol.filter(methodSymbol2 -> !methodSymbol2.isExport()).map(methodSymbol1 -> new CallData(((MD)mdObject.get()).getName(), methodSymbol1.getName(), symbolOccurrence.getLocation().getRange(), true, true));
    }

    private void fireIssue(CallData callData) {
        String message = !callData.exists ? this.info.getMessage(new Object[]{callData.methodName, callData.moduleName}) : this.info.getResourceString("privateMethod", new Object[]{callData.methodName, callData.moduleName});
        this.diagnosticStorage.addDiagnostic(callData.moduleMethodRange, message);
    }

    @ConstructorProperties(value={"locationRepository"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MissingCommonModuleMethodDiagnostic(LocationRepository locationRepository) {
        this.locationRepository = locationRepository;
    }
}

