/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.Annotation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.AnnotationKind;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Optional;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.SymbolKind;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.STANDARD})
public class NonExportMethodsInApiRegionDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern REGION_NAME = CaseInsensitivePattern.compile((String)"^(?:\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441|\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441|Public|Internal)$");
    private static final boolean SKIP_ANNOTATED_METHODS = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean skipAnnotatedMethods = false;

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        Optional optionalMethodSymbol = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx);
        if (this.skipAnnotatedMethods && optionalMethodSymbol.stream().flatMap(methodSymbol -> methodSymbol.getAnnotations().stream()).map(Annotation::getKind).anyMatch(kind -> kind != AnnotationKind.CUSTOM)) {
            return ctx;
        }
        optionalMethodSymbol.ifPresent(methodSymbol -> {
            if (methodSymbol.isExport()) {
                return;
            }
            methodSymbol.getRootParent(SymbolKind.Namespace).ifPresent(rootRegion -> {
                if (REGION_NAME.matcher(rootRegion.getName()).matches()) {
                    String message = this.info.getMessage(new Object[]{methodSymbol.getName(), rootRegion.getName()});
                    this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), message);
                }
            });
        });
        return ctx;
    }
}

