/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=30, tags={DiagnosticTag.STANDARD, DiagnosticTag.BRAINOVERLOAD})
public class NumberOfParamsDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int MAX_PARAMS_COUNT = 7;
    @DiagnosticParameter(type=Integer.class, defaultValue="7")
    private int maxParamsCount = 7;

    public ParseTree visitParamList(BSLParser.ParamListContext ctx) {
        int paramCount = ctx.param().size();
        if (paramCount > this.maxParamsCount) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(new Object[]{paramCount, this.maxParamsCount}));
        }
        return ctx;
    }
}

