/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.ModuleSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.mdo.CommonModule;
import com.github._1c_syntax.bsl.types.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.SymbolKind;

@DiagnosticMetadata(type=DiagnosticType.SECURITY_HOTSPOT, severity=DiagnosticSeverity.MAJOR, minutesToFix=60, tags={DiagnosticTag.SUSPICIOUS}, scope=DiagnosticScope.BSL)
public class PrivilegedModuleMethodCallDiagnostic
extends AbstractDiagnostic {
    private static final boolean VALIDATE_NESTED_CALLS = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean validateNestedCalls = true;
    private final ReferenceIndex referenceIndex;
    private List<ModuleSymbol> privilegedModuleSymbols = new ArrayList();

    protected void check() {
        if (this.privilegedModuleSymbols.isEmpty()) {
            this.privilegedModuleSymbols = this.getPrivilegedModuleSymbols();
        }
        if (this.privilegedModuleSymbols.isEmpty()) {
            return;
        }
        this.referenceIndex.getReferencesFrom(this.documentContext.getUri(), SymbolKind.Method).stream().filter(arg_0 -> this.isReferenceToModules(arg_0)).forEach(arg_0 -> this.fireIssue(arg_0));
    }

    private List<ModuleSymbol> getPrivilegedModuleSymbols() {
        return this.documentContext.getServerContext().getConfiguration().getCommonModules().stream().filter(CommonModule::isPrivileged).flatMap(mdCommonModule -> this.getPrivilegedModuleSymbol(mdCommonModule).stream()).toList();
    }

    private Optional<ModuleSymbol> getPrivilegedModuleSymbol(CommonModule mdCommonModule) {
        return this.documentContext.getServerContext().getDocument(mdCommonModule.getMdoReference().getMdoRef(), ModuleType.CommonModule).map(documentContext1 -> documentContext1.getSymbolTree().getModule());
    }

    private boolean isReferenceToModules(Reference reference) {
        if (!this.validateNestedCalls && reference.getUri().equals(this.documentContext.getUri())) {
            return false;
        }
        return reference.getSourceDefinedSymbol().flatMap(sourceDefinedSymbol -> sourceDefinedSymbol.getRootParent(SymbolKind.Module)).filter(ModuleSymbol.class::isInstance).map(ModuleSymbol.class::cast).filter(this.privilegedModuleSymbols::contains).isPresent();
    }

    private void fireIssue(Reference reference) {
        this.diagnosticStorage.addDiagnostic(reference.getSelectionRange(), this.info.getMessage(new Object[]{reference.getSymbol().getName()}));
    }

    @ConstructorProperties(value={"referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrivilegedModuleMethodCallDiagnostic(ReferenceIndex referenceIndex) {
        this.referenceIndex = referenceIndex;
    }
}

