/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.mdo.Attribute;
import com.github._1c_syntax.bsl.mdo.AttributeOwner;
import com.github._1c_syntax.bsl.mdo.ChildrenOwner;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.TabularSectionOwner;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.StringInterner;
import java.util.List;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=30, tags={DiagnosticTag.STANDARD, DiagnosticTag.SQL, DiagnosticTag.DESIGN}, modules={ModuleType.ManagerModule, ModuleType.ObjectModule, ModuleType.SessionModule}, scope=DiagnosticScope.BSL, canLocateOnProject=true)
public class SameMetadataObjectAndChildNamesDiagnostic
extends AbstractMetadataDiagnostic {
    private final LanguageServerConfiguration serverConfiguration;
    private final StringInterner stringInterner;

    SameMetadataObjectAndChildNamesDiagnostic(LanguageServerConfiguration serverConfiguration, StringInterner stringInterner) {
        super(List.of(MDOType.ACCOUNTING_REGISTER, MDOType.ACCUMULATION_REGISTER, MDOType.BUSINESS_PROCESS, MDOType.CALCULATION_REGISTER, MDOType.CATALOG, MDOType.CHART_OF_ACCOUNTS, MDOType.CHART_OF_CALCULATION_TYPES, MDOType.CHART_OF_CHARACTERISTIC_TYPES, MDOType.DOCUMENT, MDOType.EXCHANGE_PLAN, MDOType.INFORMATION_REGISTER, MDOType.TASK));
        this.serverConfiguration = serverConfiguration;
        this.stringInterner = stringInterner;
    }

    protected void checkMetadata(MD mdo) {
        TabularSectionOwner tabularSectionOwner;
        AttributeOwner attributeOwner;
        if (!(mdo instanceof ChildrenOwner)) {
            return;
        }
        if (mdo instanceof AttributeOwner && !(attributeOwner = (AttributeOwner)mdo).getAllAttributes().isEmpty()) {
            String mdoName = this.stringInterner.intern(mdo.getName());
            this.checkkAttributes(attributeOwner.getAllAttributes(), mdoName);
        }
        if (mdo instanceof TabularSectionOwner && !(tabularSectionOwner = (TabularSectionOwner)mdo).getTabularSections().isEmpty()) {
            tabularSectionOwner.getTabularSections().forEach(table -> {
                String tableName = this.stringInterner.intern(table.getName());
                this.checkkAttributes(table.getAllAttributes(), tableName);
            });
        }
    }

    private void checkkAttributes(List<Attribute> attributeOwner, String mdoName) {
        attributeOwner.stream().filter(attribute -> mdoName.equalsIgnoreCase(attribute.getName())).forEach(attribute -> this.addAttributeDiagnostic(attribute, mdoName));
    }

    private void addAttributeDiagnostic(Attribute attribute, String mdoName) {
        String mdoRef = this.serverConfiguration.getLanguage() == Language.RU ? attribute.getMdoReference().getMdoRefRu() : attribute.getMdoReference().getMdoRef();
        this.addDiagnostic(this.info.getMessage(new Object[]{mdoRef, mdoName}));
    }
}

