/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class SemicolonPresenceDiagnostic
extends AbstractVisitorDiagnostic
implements QuickFixProvider {
    public ParseTree visitStatement(BSLParser.StatementContext ctx) {
        if (ctx.preprocessor() == null && ctx.SEMICOLON() == null && ctx.getStop() != null) {
            if (Trees.treeContainsErrors((ParseTree)ctx)) {
                return ctx;
            }
            this.diagnosticStorage.addDiagnostic(ctx.getStop());
        }
        return (ParseTree)super.visitStatement(ctx);
    }

    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList textEdits = new ArrayList();
        diagnostics.forEach(diagnostic -> {
            Range diagnosticRange = diagnostic.getRange();
            Position diagnosticRangeEnd = diagnosticRange.getEnd();
            Range range = new Range(diagnosticRangeEnd, diagnosticRangeEnd);
            TextEdit textEdit = new TextEdit(range, ";");
            textEdits.add(textEdit);
        });
        return CodeActionProvider.createCodeActions(textEdits, (String)this.info.getResourceString("quickFixMessage"), (URI)documentContext.getUri(), diagnostics);
    }
}

