/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.DiagnosticStorage;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.recognizer.BSLFootprint;
import com.github._1c_syntax.bsl.languageserver.recognizer.CodeRecognizer;
import com.github._1c_syntax.bsl.languageserver.recognizer.LanguageFootprint;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=1, tags={DiagnosticTag.STANDARD})
public class SpaceAtStartCommentDiagnostic
extends AbstractDiagnostic
implements QuickFixProvider {
    private static final String DEFAULT_COMMENTS_ANNOTATION = "//@,//(c),//\u00a9";
    private static final Pattern GOOD_COMMENT_PATTERN = CaseInsensitivePattern.compile((String)"(?:(?:\\/{2,}[ \\t].*)|(?:\\/{2,}[ \\t]*))$");
    private static final Pattern GOOD_COMMENT_PATTERN_STRICT = CaseInsensitivePattern.compile((String)"(?:(?:\\/\\/[ \\t].*)|(?:\\/{2,}[ \\t]*))$");
    private static final boolean USE_STRICT_VALIDATION = true;
    private static final int COMMENT_LENGTH = 2;
    private static final float COMMENTED_CODE_THRESHOLD = 0.9f;
    private final CodeRecognizer codeRecognizer;
    @DiagnosticParameter(type=String.class, defaultValue="//@,//(c),//\u00a9")
    private Pattern commentsAnnotation = DiagnosticHelper.createPatternFromString((String)"//@,//(c),//\u00a9");
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean useStrictValidation = true;

    public SpaceAtStartCommentDiagnostic() {
        this.codeRecognizer = new CodeRecognizer((double)0.9f, (LanguageFootprint)new BSLFootprint());
    }

    public void configure(Map<String, Object> configuration) {
        DiagnosticHelper.configureDiagnostic((BSLDiagnostic)this, configuration, (String[])new String[]{"useStrictValidation"});
        this.commentsAnnotation = DiagnosticHelper.createPatternFromString((String)((String)configuration.getOrDefault("commentsAnnotation", DEFAULT_COMMENTS_ANNOTATION)));
    }

    public void check() {
        ((Stream)this.documentContext.getComments().parallelStream().filter(t -> !this.goodPattern().matcher(t.getText()).matches() && !this.commentsAnnotation.matcher(t.getText()).matches() && !this.codeRecognizer.meetsCondition(t.getText())).sequential()).forEach(arg_0 -> ((DiagnosticStorage)this.diagnosticStorage).addDiagnostic(arg_0));
    }

    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList textEdits = new ArrayList();
        diagnostics.forEach(diagnostic -> {
            Range range = diagnostic.getRange();
            String currentText = documentContext.getText(range);
            TextEdit textEdit = new TextEdit(range, currentText.substring(0, 2) + " " + currentText.substring(2));
            textEdits.add(textEdit);
        });
        return CodeActionProvider.createCodeActions(textEdits, (String)this.info.getResourceString("quickFixMessage"), (URI)documentContext.getUri(), diagnostics);
    }

    private Pattern goodPattern() {
        if (this.useStrictValidation) {
            return GOOD_COMMENT_PATTERN_STRICT;
        }
        return GOOD_COMMENT_PATTERN;
    }
}

