/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.CompilerDirectiveKind;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.TransferringParametersBetweenClientAndServerDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=2, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.PERFORMANCE, DiagnosticTag.STANDARD})
public class TransferringParametersBetweenClientAndServerDiagnostic
extends AbstractDiagnostic {
    private static final Set<CompilerDirectiveKind> SERVER_COMPILER_DIRECTIVE_KINDS = EnumSet.of(CompilerDirectiveKind.AT_SERVER, CompilerDirectiveKind.AT_SERVER_NO_CONTEXT);
    private final ReferenceIndex referenceIndex;

    protected void check() {
        this.calcIssues().forEach(paramReference -> paramReference.getParameterDefinitions().forEach(parameterDefinition -> this.diagnosticStorage.addDiagnostic(parameterDefinition.getRange(), this.info.getMessage(new Object[]{parameterDefinition.getName(), paramReference.getMethodSymbol().getName()}), TransferringParametersBetweenClientAndServerDiagnostic.getRelatedInformation((List)paramReference.getReferences()))));
    }

    private Stream<ParamReference> calcIssues() {
        return this.documentContext.getSymbolTree().getMethods().stream().filter(TransferringParametersBetweenClientAndServerDiagnostic::isEqualCompilerDirectives).flatMap(methodSymbol -> this.getParamReference(methodSymbol).stream());
    }

    private Optional<ParamReference> getParamReference(MethodSymbol method) {
        List parameterDefinitions = this.calcNotAssignedParams(method);
        if (parameterDefinitions.isEmpty()) {
            return Optional.empty();
        }
        List refsFromClientCalls = this.getRefsFromClientCalls(method);
        if (refsFromClientCalls.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ParamReference(method, parameterDefinitions, refsFromClientCalls));
    }

    private List<ParameterDefinition> calcNotAssignedParams(MethodSymbol method) {
        List parameterDefinitions = TransferringParametersBetweenClientAndServerDiagnostic.getMethodParamsByRef((MethodSymbol)method);
        if (parameterDefinitions.isEmpty()) {
            return Collections.emptyList();
        }
        return this.calcNotAssignedParams(method, parameterDefinitions);
    }

    private List<ParameterDefinition> calcNotAssignedParams(MethodSymbol method, List<ParameterDefinition> parameterDefinitions) {
        return parameterDefinitions.stream().filter(parameterDefinition -> this.isAssignedParam(method, parameterDefinition)).toList();
    }

    private boolean isAssignedParam(MethodSymbol method, ParameterDefinition parameterDefinition) {
        return TransferringParametersBetweenClientAndServerDiagnostic.getVariableByParameter((MethodSymbol)method, (ParameterDefinition)parameterDefinition).noneMatch(variableSymbol -> this.referenceIndex.getReferencesTo((SourceDefinedSymbol)variableSymbol).stream().anyMatch(ref -> ref.getOccurrenceType() == OccurrenceType.DEFINITION));
    }

    private static Stream<VariableSymbol> getVariableByParameter(MethodSymbol method, ParameterDefinition parameterDefinition) {
        return method.getChildren().stream().filter(sourceDefinedSymbol -> sourceDefinedSymbol.getSymbolKind() == SymbolKind.Variable).filter(variable -> parameterDefinition.getRange().getStart().equals((Object)variable.getSelectionRange().getStart())).filter(VariableSymbol.class::isInstance).map(VariableSymbol.class::cast).findFirst().stream();
    }

    private List<Reference> getRefsFromClientCalls(MethodSymbol method) {
        return this.referenceIndex.getReferencesTo((SourceDefinedSymbol)method).stream().filter(ref -> ref.getOccurrenceType() == OccurrenceType.REFERENCE).filter(TransferringParametersBetweenClientAndServerDiagnostic::isClientCall).collect(Collectors.toUnmodifiableList());
    }

    private static boolean isClientCall(Reference ref) {
        return Optional.of(ref.getFrom()).filter(MethodSymbol.class::isInstance).map(MethodSymbol.class::cast).filter(TransferringParametersBetweenClientAndServerDiagnostic::isEqualCompilerDirective).isPresent();
    }

    private static boolean isEqualCompilerDirectives(MethodSymbol method) {
        return method.getCompilerDirectiveKind().filter(SERVER_COMPILER_DIRECTIVE_KINDS::contains).isPresent();
    }

    private static boolean isEqualCompilerDirective(MethodSymbol method) {
        return method.getCompilerDirectiveKind().filter(compilerDirective -> compilerDirective == CompilerDirectiveKind.AT_CLIENT).isPresent();
    }

    private static List<ParameterDefinition> getMethodParamsByRef(MethodSymbol methodSymbol) {
        return methodSymbol.getParameters().stream().filter(parameterDefinition -> !parameterDefinition.isByValue()).toList();
    }

    private static List<DiagnosticRelatedInformation> getRelatedInformation(List<Reference> references) {
        return references.stream().map(reference -> RelatedInformation.create((URI)reference.getUri(), (Range)reference.getSelectionRange(), (String)"+1")).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TransferringParametersBetweenClientAndServerDiagnostic(ReferenceIndex referenceIndex) {
        this.referenceIndex = referenceIndex;
    }
}

