/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractFindMethodDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, scope=DiagnosticScope.BSL, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_1, minutesToFix=1, tags={DiagnosticTag.DEPRECATED, DiagnosticTag.ERROR})
public class UnsafeSafeModeMethodCallDiagnostic
extends AbstractFindMethodDiagnostic {
    private static final Pattern SAFE_MODE_METHOD_NAME = CaseInsensitivePattern.compile((String)"(\u0411\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u044b\u0439\u0420\u0435\u0436\u0438\u043c|SafeMode)");
    private static final Set<Integer> ROOT_LIST = Set.of(Integer.valueOf(48), Integer.valueOf(49), Integer.valueOf(84), Integer.valueOf(72), Integer.valueOf(81));
    private static final Set<Integer> IF_BRANCHES = Set.of(Integer.valueOf(48), Integer.valueOf(49));

    public UnsafeSafeModeMethodCallDiagnostic() {
        super(SAFE_MODE_METHOD_NAME);
    }

    protected boolean checkMethodCall(BSLParser.MethodCallContext ctx) {
        return false;
    }

    protected boolean checkGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        if (!super.checkGlobalMethodCall(ctx)) {
            return false;
        }
        BSLParser.MemberContext currentRootMember = (BSLParser.MemberContext)Trees.getRootParent((BSLParserRuleContext)ctx, (int)89);
        if (currentRootMember == null) {
            return false;
        }
        return UnsafeSafeModeMethodCallDiagnostic.nonValidExpression((BSLParser.MemberContext)currentRootMember);
    }

    private static boolean nonValidExpression(BSLParser.MemberContext currentRootMember) {
        if (currentRootMember.unaryModifier() != null) {
            return true;
        }
        BSLParserRuleContext rootExpressionNode = currentRootMember.getParent();
        BSLParserRuleContext rootIfNode = Trees.getRootParent((BSLParserRuleContext)rootExpressionNode, (Collection)ROOT_LIST);
        if (rootIfNode == null || rootIfNode.getRuleIndex() == 72) {
            return false;
        }
        if (rootExpressionNode.getChildCount() == 1 && IF_BRANCHES.contains(rootIfNode.getRuleIndex())) {
            return true;
        }
        return UnsafeSafeModeMethodCallDiagnostic.haveNeighboorBooleanOperator((BSLParserRuleContext)currentRootMember, (BSLParserRuleContext)rootExpressionNode);
    }

    private static boolean haveNeighboorBooleanOperator(BSLParserRuleContext currentRootMember, BSLParserRuleContext rootExpressionNode) {
        boolean haveNeighbourBoolOperation = false;
        int indexOfCurrentMemberNode = rootExpressionNode.children.indexOf(currentRootMember);
        if (indexOfCurrentMemberNode > 0) {
            BSLParserRuleContext prev = (BSLParserRuleContext)rootExpressionNode.children.get(indexOfCurrentMemberNode - 1);
            if (Trees.nodeContains((ParseTree)prev, (Integer[])new Integer[]{86})) {
                return false;
            }
            haveNeighbourBoolOperation = Trees.nodeContains((ParseTree)prev, (Integer[])new Integer[]{87});
        }
        if (indexOfCurrentMemberNode < rootExpressionNode.getChildCount() - 1) {
            BSLParserRuleContext next = (BSLParserRuleContext)rootExpressionNode.children.get(indexOfCurrentMemberNode + 1);
            if (Trees.nodeContains((ParseTree)next, (Integer[])new Integer[]{86})) {
                return false;
            }
            if (!haveNeighbourBoolOperation) {
                haveNeighbourBoolOperation = Trees.nodeContains((ParseTree)next, (Integer[])new Integer[]{87});
            }
        }
        return haveNeighbourBoolOperation;
    }
}

