/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.VULNERABILITY, severity=DiagnosticSeverity.CRITICAL, minutesToFix=15, tags={DiagnosticTag.STANDARD})
public class UsingHardcodeNetworkAddressDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String REGEX_NETWORK_ADDRESS = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|(?<![g-z\u0430-\u044f\u0410-\u042f\u0451\u0401]):((:[0-9a-fA-F]{1,4}){1,7}|\\s:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))|((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])";
    private static final int DOTS_IN_IPV4 = 3;
    private static final String REGEX_URL = "^(ftp|http|https):\\/\\/[^ \"].*";
    private static final String REGEX_EXCLUSION = "\u0412\u0435\u0440\u0441\u0438|Version|\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435|RunApp|\u041f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432|Namespace|\u0414\u0440\u0430\u0439\u0432\u0435\u0440|Driver";
    private static final String REGEX_ALPHABET = "[A-z\u0410-\u044f]";
    private static final String REGEX_POPULAR_VERSION = "^(1|2|3|8\\.3|11)\\.";
    private static final Pattern patternNetworkAddress = CaseInsensitivePattern.compile((String)"(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|(?<![g-z\u0430-\u044f\u0410-\u042f\u0451\u0401]):((:[0-9a-fA-F]{1,4}){1,7}|\\s:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))|((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])");
    private static final Pattern patternURL = CaseInsensitivePattern.compile((String)"^(ftp|http|https):\\/\\/[^ \"].*");
    private static final Pattern patternAlphabet = CaseInsensitivePattern.compile((String)"[A-z\u0410-\u044f]");
    @DiagnosticParameter(type=String.class, defaultValue="\u0412\u0435\u0440\u0441\u0438|Version|\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435|RunApp|\u041f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432|Namespace|\u0414\u0440\u0430\u0439\u0432\u0435\u0440|Driver")
    private Pattern searchWordsExclusion = CaseInsensitivePattern.compile((String)"\u0412\u0435\u0440\u0441\u0438|Version|\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435|RunApp|\u041f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432|Namespace|\u0414\u0440\u0430\u0439\u0432\u0435\u0440|Driver");
    @DiagnosticParameter(type=String.class, defaultValue="^(1|2|3|8\\.3|11)\\.")
    private Pattern searchPopularVersionExclusion = CaseInsensitivePattern.compile((String)"^(1|2|3|8\\.3|11)\\.");

    public void configure(Map<String, Object> configuration) {
        String searchWordsExclusionProperty = (String)configuration.getOrDefault("searchWordsExclusion", REGEX_EXCLUSION);
        this.searchWordsExclusion = CaseInsensitivePattern.compile((String)searchWordsExclusionProperty);
        String searchPopularVersionExclusionProperty = (String)configuration.getOrDefault("searchPopularVersionExclusion", REGEX_POPULAR_VERSION);
        this.searchPopularVersionExclusion = CaseInsensitivePattern.compile((String)searchPopularVersionExclusionProperty);
    }

    public ParseTree visitString(BSLParser.StringContext ctx) {
        Matcher matcherURL;
        String content = ctx.getText().substring(1, ctx.getText().length() - 1);
        if (content.length() > 2 && !(matcherURL = patternURL.matcher(content)).find()) {
            this.processVisitString(ctx, content);
        }
        return ctx;
    }

    private void processVisitString(BSLParser.StringContext ctx, String content) {
        Matcher matcher = patternNetworkAddress.matcher(content);
        if (matcher.find()) {
            String firstValue = matcher.group(0);
            int countDots = (int)firstValue.chars().filter(num -> num == 46).count();
            int countDotsAll = (int)content.chars().filter(num -> num == 46).count();
            matcher = patternAlphabet.matcher(firstValue);
            boolean findAlphabet = matcher.find();
            if (countDots > 0 && (countDotsAll > 3 || findAlphabet)) {
                return;
            }
            if (this.skipStatement((BSLParserRuleContext)ctx, 80) || this.skipStatement((BSLParserRuleContext)ctx, 75) || this.itVersionReturn((BSLParserRuleContext)ctx)) {
                return;
            }
            if (this.searchPopularVersionExclusion.matcher(content).find()) {
                return;
            }
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
        }
    }

    private boolean itVersionReturn(BSLParserRuleContext ctx) {
        BSLParserRuleContext returnState = Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, (int)55);
        if (returnState != null) {
            return this.skipStatement(returnState, 40);
        }
        return false;
    }

    private boolean skipStatement(BSLParserRuleContext ctx, int ruleStatement) {
        BSLParserRuleContext parent = Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, (int)ruleStatement);
        if (parent != null) {
            Matcher matcher = this.searchWordsExclusion.matcher(parent.getText());
            return matcher.find();
        }
        return false;
    }
}

