/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, scope=DiagnosticScope.BSL, minutesToFix=15, tags={DiagnosticTag.STANDARD})
public class UsingHardcodePathDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String REGEX_PATH = "^(?=\\/).*|^(%.*%)(?=\\\\|\\/|\\/\\/)|^(~)(?=\\\\|\\/|\\/\\/)|(^([a-z]):(?=\\\\|\\/\\/(?![\u0000-\u001f<>:\"\\/\\\\|?*])|\\/(?![\u0000-\u001f<>:\"\\/\\\\|?*])|$)|^\\\\(?=[\\\\\\/][^\u0000-\u001f<>:\"\\/\\\\|?*]+)|^(?=(\\\\|\\/|\\/\\/)$)^\\.(?=(\\\\|\\/|\\/\\/)[^\u0000-\u001f<>:\"\\/\\\\|?*]+))((\\\\|\\/|\\/\\/)[^\u0000-\u001f<>:\"\\/\\\\|?*]+|(\\\\|\\/|\\/\\/)$)*()$";
    private static final String REGEX_STD_PATHS_UNIX = "bin|boot|dev|etc|home|lib|lost\\+found|misc|mnt|media|opt|proc|root|run|sbin|tmp|usr|var";
    private static final String REGEX_URL = "^(ftp|http|https):\\/\\/[^ \"].*";
    private static final Pattern patternPath = CaseInsensitivePattern.compile((String)"^(?=\\/).*|^(%.*%)(?=\\\\|\\/|\\/\\/)|^(~)(?=\\\\|\\/|\\/\\/)|(^([a-z]):(?=\\\\|\\/\\/(?![\u0000-\u001f<>:\"\\/\\\\|?*])|\\/(?![\u0000-\u001f<>:\"\\/\\\\|?*])|$)|^\\\\(?=[\\\\\\/][^\u0000-\u001f<>:\"\\/\\\\|?*]+)|^(?=(\\\\|\\/|\\/\\/)$)^\\.(?=(\\\\|\\/|\\/\\/)[^\u0000-\u001f<>:\"\\/\\\\|?*]+))((\\\\|\\/|\\/\\/)[^\u0000-\u001f<>:\"\\/\\\\|?*]+|(\\\\|\\/|\\/\\/)$)*()$");
    private static final Pattern patternURL = CaseInsensitivePattern.compile((String)"^(ftp|http|https):\\/\\/[^ \"].*");
    @DiagnosticParameter(type=String.class, defaultValue="bin|boot|dev|etc|home|lib|lost\\+found|misc|mnt|media|opt|proc|root|run|sbin|tmp|usr|var")
    private Pattern searchWordsStdPathsUnix = CaseInsensitivePattern.compile((String)"^\\/(bin|boot|dev|etc|home|lib|lost\\+found|misc|mnt|media|opt|proc|root|run|sbin|tmp|usr|var)");

    public void configure(Map<String, Object> configuration) {
        String searchWordsStdPathsUnixProperty = (String)configuration.getOrDefault("searchWordsStdPathsUnix", REGEX_STD_PATHS_UNIX);
        this.searchWordsStdPathsUnix = CaseInsensitivePattern.compile((String)("^\\/(" + searchWordsStdPathsUnixProperty + ")"));
    }

    public ParseTree visitString(BSLParser.StringContext ctx) {
        if (ctx.getText().length() > 4) {
            String content = ctx.getText().substring(1, ctx.getText().length() - 1);
            Matcher matcher = patternPath.matcher(content);
            Matcher matcherURL = patternURL.matcher(content);
            if (matcher.find() && !matcherURL.find()) {
                this.processVisitString(ctx, content);
            }
        }
        return ctx;
    }

    private void processVisitString(BSLParser.StringContext ctx, String content) {
        Matcher matcher;
        if (content.startsWith("/") && !(matcher = this.searchWordsStdPathsUnix.matcher(content)).find()) {
            return;
        }
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
    }
}

