/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, scope=DiagnosticScope.BSL, minutesToFix=30, tags={DiagnosticTag.STANDARD, DiagnosticTag.LOCKINOS})
public class UsingObjectNotAvailableUnixDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern patternNewExpression = CaseInsensitivePattern.compile((String)"^(COM\u041e\u0431\u044a\u0435\u043a\u0442|COMObject|\u041f\u043e\u0447\u0442\u0430|Mail)");
    private static final Pattern patternTypePlatform = CaseInsensitivePattern.compile((String)"Linux_x86|Windows|MacOS");

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        BSLParser.TypeNameContext typeNameContext = ctx.typeName();
        if (typeNameContext == null) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        Matcher matcherTypeName = patternNewExpression.matcher(typeNameContext.getText());
        if (matcherTypeName.find() && !UsingObjectNotAvailableUnixDiagnostic.isFindIfBranchWithLinuxCondition((BSLParserRuleContext)ctx)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(new Object[]{typeNameContext.getText()}));
        }
        return (ParseTree)super.visitNewExpression(ctx);
    }

    private static boolean isFindIfBranchWithLinuxCondition(BSLParserRuleContext element) {
        BSLParserRuleContext ancestor = Trees.getAncestorByRuleIndex((BSLParserRuleContext)element, (int)48);
        if (ancestor == null) {
            return false;
        }
        String content = ancestor.getText();
        Matcher matcher = patternTypePlatform.matcher(content);
        if (matcher.find()) {
            return true;
        }
        return UsingObjectNotAvailableUnixDiagnostic.isFindIfBranchWithLinuxCondition((BSLParserRuleContext)ancestor);
    }
}

