/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, tags={DiagnosticTag.BADPRACTICE})
public class UsingServiceTagDiagnostic
extends AbstractDiagnostic {
    private static final String SERVICE_TAGS_DEFAULT = "todo|fixme|!!|mrg|@|\u043e\u0442\u043b\u0430\u0434\u043a\u0430|debug|\u0434\u043b\u044f\\s*\u043e\u0442\u043b\u0430\u0434\u043a\u0438|(\\{\\{|\\}\\})\u041a\u041e\u041d\u0421\u0422\u0420\u0423\u041a\u0422\u041e\u0420_|(\\{\\{|\\}\\})MRG|\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c\\s*\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435\\s*\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430|Paste\\s*handler\\s*content|Insert\\s*handler\\s*code|Insert\\s*handler\\s*content|Insert\\s*handler\\s*contents";
    @DiagnosticParameter(type=String.class, defaultValue="todo|fixme|!!|mrg|@|\u043e\u0442\u043b\u0430\u0434\u043a\u0430|debug|\u0434\u043b\u044f\\s*\u043e\u0442\u043b\u0430\u0434\u043a\u0438|(\\{\\{|\\}\\})\u041a\u041e\u041d\u0421\u0422\u0420\u0423\u041a\u0422\u041e\u0420_|(\\{\\{|\\}\\})MRG|\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c\\s*\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435\\s*\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430|Paste\\s*handler\\s*content|Insert\\s*handler\\s*code|Insert\\s*handler\\s*content|Insert\\s*handler\\s*contents")
    private String serviceTags = "todo|fixme|!!|mrg|@|\u043e\u0442\u043b\u0430\u0434\u043a\u0430|debug|\u0434\u043b\u044f\\s*\u043e\u0442\u043b\u0430\u0434\u043a\u0438|(\\{\\{|\\}\\})\u041a\u041e\u041d\u0421\u0422\u0420\u0423\u041a\u0422\u041e\u0420_|(\\{\\{|\\}\\})MRG|\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c\\s*\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435\\s*\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430|Paste\\s*handler\\s*content|Insert\\s*handler\\s*code|Insert\\s*handler\\s*content|Insert\\s*handler\\s*contents";
    private Pattern pattern = this.getPatternSearch("todo|fixme|!!|mrg|@|\u043e\u0442\u043b\u0430\u0434\u043a\u0430|debug|\u0434\u043b\u044f\\s*\u043e\u0442\u043b\u0430\u0434\u043a\u0438|(\\{\\{|\\}\\})\u041a\u041e\u041d\u0421\u0422\u0420\u0423\u041a\u0422\u041e\u0420_|(\\{\\{|\\}\\})MRG|\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c\\s*\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435\\s*\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430|Paste\\s*handler\\s*content|Insert\\s*handler\\s*code|Insert\\s*handler\\s*content|Insert\\s*handler\\s*contents");

    public void configure(Map<String, Object> configuration) {
        this.serviceTags = (String)configuration.getOrDefault("serviceTags", this.serviceTags);
        this.pattern = this.getPatternSearch(this.serviceTags);
    }

    public Pattern getPatternSearch(String value) {
        return Pattern.compile("//\\s*+(" + value + ")", 14);
    }

    public void check() {
        this.documentContext.getComments().parallelStream().forEach(token -> {
            Matcher matcher = this.pattern.matcher(token.getText());
            if (!matcher.find()) {
                return;
            }
            this.diagnosticStorage.addDiagnostic(token, this.info.getMessage(new Object[]{matcher.group(0)}));
        });
    }
}

