/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, scope=DiagnosticScope.BSL, modules={ModuleType.FormModule}, minutesToFix=1, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_3, tags={DiagnosticTag.STANDARD, DiagnosticTag.DEPRECATED})
public class UsingThisFormDiagnostic
extends AbstractVisitorDiagnostic
implements QuickFixProvider {
    private static final Pattern PATTERN = CaseInsensitivePattern.compile((String)"^(\u044d\u0442\u0430\u0444\u043e\u0440\u043c\u0430|thisform)");
    private static final Pattern ONLY_RU_PATTERN = CaseInsensitivePattern.compile((String)"\u044d\u0442\u0430\u0444\u043e\u0440\u043c\u0430");
    private static final String THIS_OBJECT = "\u042d\u0442\u043e\u0442\u041e\u0431\u044a\u0435\u043a\u0442";
    private static final String THIS_OBJECT_EN = "ThisObject";

    public ParseTree visitProcedure(BSLParser.ProcedureContext ctx) {
        if (UsingThisFormDiagnostic.needCheck((BSLParserRuleContext)ctx.procDeclaration())) {
            return (ParseTree)super.visitProcedure(ctx);
        }
        return ctx;
    }

    public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
        if (UsingThisFormDiagnostic.needCheck((BSLParserRuleContext)ctx.funcDeclaration())) {
            return (ParseTree)super.visitFunction(ctx);
        }
        return ctx;
    }

    private static boolean needCheck(BSLParserRuleContext declaration) {
        List params = UsingThisFormDiagnostic.getParams((BSLParserRuleContext)declaration);
        return params.isEmpty() || !UsingThisFormDiagnostic.hasThisForm((List)params);
    }

    private static List<? extends BSLParser.ParamContext> getParams(BSLParserRuleContext declaration) {
        BSLParser.ParamListContext paramList = (BSLParser.ParamListContext)declaration.getRuleContext(BSLParser.ParamListContext.class, 0);
        if (paramList == null) {
            return Collections.emptyList();
        }
        return paramList.getRuleContexts(BSLParser.ParamContext.class);
    }

    private static boolean hasThisForm(List<? extends BSLParser.ParamContext> params) {
        for (BSLParser.ParamContext paramContext : params) {
            if (!PATTERN.matcher(paramContext.getText()).find()) continue;
            return true;
        }
        return false;
    }

    public ParseTree visitCallStatement(BSLParser.CallStatementContext ctx) {
        if (ctx.globalMethodCall() != null && ctx.getStart() == ctx.globalMethodCall().getStart()) {
            return (ParseTree)super.visitCallStatement(ctx);
        }
        if (PATTERN.matcher(ctx.getStart().getText()).matches()) {
            this.diagnosticStorage.addDiagnostic(ctx.getStart());
        }
        return (ParseTree)super.visitCallStatement(ctx);
    }

    public ParseTree visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
        Trees.findAllTokenNodes((ParseTree)ctx, (int)76).stream().filter(token -> PATTERN.matcher(token.getText()).matches()).forEach(token -> this.diagnosticStorage.addDiagnostic((TerminalNode)token));
        return ctx;
    }

    public List<CodeAction> getQuickFixes(List<Diagnostic> diagnostics, CodeActionParams params, DocumentContext documentContext) {
        ArrayList<TextEdit> newTextEdits = new ArrayList<TextEdit>();
        for (Diagnostic diagnostic : diagnostics) {
            newTextEdits.add(UsingThisFormDiagnostic.getQuickFixText((Diagnostic)diagnostic, (DocumentContext)documentContext));
        }
        return CodeActionProvider.createCodeActions(newTextEdits, (String)this.info.getResourceString("quickFixMessage"), (URI)documentContext.getUri(), diagnostics);
    }

    public ParseTree visitLValue(BSLParser.LValueContext ctx) {
        TerminalNode identifier = ctx.IDENTIFIER();
        if (identifier != null && PATTERN.matcher(identifier.getText()).matches()) {
            this.diagnosticStorage.addDiagnostic(identifier);
        }
        return (ParseTree)super.visitLValue(ctx);
    }

    private static TextEdit getQuickFixText(Diagnostic diagnostic, DocumentContext documentContext) {
        Range range = diagnostic.getRange();
        String currentText = documentContext.getText(range);
        if (ONLY_RU_PATTERN.matcher(currentText).matches()) {
            return new TextEdit(range, "\u042d\u0442\u043e\u0442\u041e\u0431\u044a\u0435\u043a\u0442");
        }
        return new TextEdit(range, "ThisObject");
    }
}

