/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.mdo.Form;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.storage.FormData;
import com.github._1c_syntax.bsl.mdo.storage.form.FormItem;
import com.github._1c_syntax.bsl.mdo.support.ScriptVariant;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.lsp4j.Range;

/*
 * Exception performing whole class analysis ignored.
 */
@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=5, scope=DiagnosticScope.BSL, modules={ModuleType.FormModule, ModuleType.ManagedApplicationModule}, tags={DiagnosticTag.UNPREDICTABLE})
public class WrongDataPathForFormElementsDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;

    protected void check() {
        Range range = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (!Ranges.isEmpty((Range)range)) {
            this.checkCurrentModule(range);
        }
    }

    private static boolean wrongDataPath(FormItem formItem) {
        return formItem.getDataPath().getSegments().startsWith("~");
    }

    private static boolean haveFormModules(Form form) {
        return !form.getModules().isEmpty();
    }

    private void checkCurrentModule(Range range) {
        this.diagnosticRange = range;
        if (this.documentContext.getModuleType() == ModuleType.FormModule) {
            this.checkMdoObjectStream(WrongDataPathForFormElementsDiagnostic::haveFormModules, this.documentContext.getMdObject().stream());
        } else {
            this.checkAllFormsWithoutModules();
        }
    }

    private void checkAllFormsWithoutModules() {
        this.checkMdoObjectStream(form -> !WrongDataPathForFormElementsDiagnostic.haveFormModules((Form)form), this.documentContext.getServerContext().getConfiguration().getPlainChildren().stream());
    }

    private void checkMdoObjectStream(Predicate<Form> formFilter, Stream<MD> stream) {
        stream.filter(Form.class::isInstance).map(Form.class::cast).filter(formFilter).forEach(arg_0 -> this.checkForm(arg_0));
    }

    private void checkForm(Form form) {
        FormData formData = form.getData();
        if (formData.isEmpty()) {
            return;
        }
        formData.getPlainItems().stream().filter(WrongDataPathForFormElementsDiagnostic::wrongDataPath).forEach(formItem -> this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(new Object[]{formItem.getName(), this.getMdoRef(form)})));
    }

    private String getMdoRef(Form form) {
        if (this.documentContext.getServerContext().getConfiguration().getScriptVariant() == ScriptVariant.ENGLISH) {
            return form.getMdoReference().getMdoRef();
        }
        return form.getMdoReference().getMdoRefRu();
    }
}

