/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.mdo.HTTPService;
import com.github._1c_syntax.bsl.types.ModuleType;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=10, tags={DiagnosticTag.SUSPICIOUS, DiagnosticTag.ERROR}, scope=DiagnosticScope.BSL, modules={ModuleType.HTTPServiceModule})
public class WrongHttpServiceHandlerDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;

    protected void check() {
        this.diagnosticRange = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (!Ranges.isEmpty((Range)this.diagnosticRange)) {
            this.processModule();
        }
    }

    private void processModule() {
        this.documentContext.getMdObject().filter(HTTPService.class::isInstance).map(HTTPService.class::cast).ifPresent(arg_0 -> this.checkService(arg_0));
    }

    private void checkService(HTTPService httpService) {
        httpService.getUrlTemplates().stream().flatMap(httpServiceURLTemplate -> httpServiceURLTemplate.getMethods().stream()).forEach(service -> {
            String serviceName = service.getMdoReference().getMdoRef();
            if (service.getHandler().isEmpty()) {
                this.addMissingHandlerDiagnostic(serviceName);
                return;
            }
            this.checkMethod(serviceName, service.getHandler());
        });
    }

    private void checkMethod(String serviceName, String handlerName) {
        this.documentContext.getSymbolTree().getMethodSymbol(handlerName).ifPresentOrElse(methodSymbol -> this.checkMethodParams(serviceName, handlerName, methodSymbol), () -> this.addDefaultDiagnostic(serviceName, handlerName));
    }

    private void checkMethodParams(String serviceName, String handlerName, MethodSymbol methodSymbol) {
        if (methodSymbol.getParameters().size() != 1) {
            this.addIncorrectHandlerDiagnostic(methodSymbol.getSubNameRange(), serviceName, handlerName);
        }
    }

    private void addDefaultDiagnostic(String serviceName, String handlerName) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(new Object[]{handlerName, serviceName}));
    }

    private void addMissingHandlerDiagnostic(String serviceName) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getResourceString("missingHandler", new Object[]{serviceName}));
    }

    private void addIncorrectHandlerDiagnostic(Range range, String serviceName, String handlerName) {
        this.diagnosticStorage.addDiagnostic(range, this.info.getResourceString("incorrectHandler", new Object[]{handlerName, serviceName}));
    }
}

