/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractFindMethodDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=1, scope=DiagnosticScope.BSL, tags={DiagnosticTag.STANDARD})
public class WrongUseOfRollbackTransactionMethodDiagnostic
extends AbstractFindMethodDiagnostic {
    private static final Pattern MESSAGE_PATTERN = CaseInsensitivePattern.compile((String)"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|RollbackTransaction");

    public WrongUseOfRollbackTransactionMethodDiagnostic() {
        super(MESSAGE_PATTERN);
    }

    protected boolean checkGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        BSLParserRuleContext parentNode = Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, (int)63);
        if (parentNode == null) {
            return MESSAGE_PATTERN.matcher(ctx.methodName().getText()).matches();
        }
        List methodsList = Trees.findAllRuleNodes((ParseTree)parentNode, (int)93).stream().map(BSLParser.GlobalMethodCallContext.class::cast).map(e -> e.methodName().getText()).collect(Collectors.toList());
        if (MESSAGE_PATTERN.matcher(ctx.methodName().getText()).matches()) {
            return methodsList.indexOf(ctx.methodName().getText()) != 0;
        }
        return false;
    }

    protected boolean checkMethodCall(BSLParser.MethodCallContext ctx) {
        return false;
    }
}

