/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.mdo.WebService;
import com.github._1c_syntax.bsl.mdo.children.WebServiceOperation;
import com.github._1c_syntax.bsl.types.ModuleType;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, minutesToFix=10, tags={DiagnosticTag.SUSPICIOUS, DiagnosticTag.ERROR}, scope=DiagnosticScope.BSL, modules={ModuleType.WEBServiceModule})
public class WrongWebServiceHandlerDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;

    protected void check() {
        this.diagnosticRange = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (!Ranges.isEmpty((Range)this.diagnosticRange)) {
            this.processModule();
        }
    }

    private void processModule() {
        this.documentContext.getMdObject().filter(WebService.class::isInstance).map(WebService.class::cast).ifPresent(arg_0 -> this.checkService(arg_0));
    }

    private void checkService(WebService mdWebService) {
        mdWebService.getOperations().forEach(webServiceOperation -> this.checkOperation(mdWebService.getName(), webServiceOperation));
    }

    private void checkOperation(String serviceName, WebServiceOperation webServiceOperation) {
        String operationName = webServiceOperation.getName();
        String handler = webServiceOperation.getProcedureName();
        if (handler.isEmpty()) {
            this.addMissingHandlerDiagnostic(serviceName, operationName);
            return;
        }
        this.checkMethod(serviceName, operationName, handler);
    }

    private void checkMethod(String serviceName, String operationName, String handlerName) {
        if (this.documentContext.getSymbolTree().getMethodSymbol(handlerName).isEmpty()) {
            this.addDefaultDiagnostic(serviceName, operationName, handlerName);
        }
    }

    private void addDefaultDiagnostic(String serviceName, String operationName, String handlerName) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(new Object[]{handlerName, operationName, serviceName}));
    }

    private void addMissingHandlerDiagnostic(String serviceName, String operationName) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getResourceString("missingHandler", new Object[]{operationName, serviceName}));
    }
}

