/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics.infrastructure;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class DiagnosticBeanPostProcessor
implements BeanPostProcessor {
    private final LanguageServerConfiguration configuration;
    private final Map<Class<? extends BSLDiagnostic>, DiagnosticInfo> diagnosticInfos;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (!BSLDiagnostic.class.isAssignableFrom(bean.getClass())) {
            return bean;
        }
        BSLDiagnostic diagnostic = (BSLDiagnostic)bean;
        DiagnosticInfo info = (DiagnosticInfo)this.diagnosticInfos.get(diagnostic.getClass());
        diagnostic.setInfo(info);
        return diagnostic;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (!BSLDiagnostic.class.isAssignableFrom(bean.getClass())) {
            return bean;
        }
        BSLDiagnostic diagnostic = (BSLDiagnostic)bean;
        Either diagnosticConfiguration = (Either)this.configuration.getDiagnosticsOptions().getParameters().get(diagnostic.getInfo().getCode().getStringValue());
        if (diagnosticConfiguration != null && diagnosticConfiguration.isRight()) {
            diagnostic.configure((Map)diagnosticConfiguration.getRight());
        }
        return diagnostic;
    }

    @ConstructorProperties(value={"configuration", "diagnosticInfos"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticBeanPostProcessor(LanguageServerConfiguration configuration, Map<Class<? extends BSLDiagnostic>, DiagnosticInfo> diagnosticInfos) {
        this.configuration = configuration;
        this.diagnosticInfos = diagnosticInfos;
    }
}

