/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics.metadata;

import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticInfo;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DiagnosticParameterInfo {
    private final Class<?> type;
    private final String name;
    private final String description;
    private final Object defaultValue;

    private DiagnosticParameterInfo(Field field, String description) {
        DiagnosticParameter diagnosticParameter = field.getAnnotation(DiagnosticParameter.class);
        this.type = diagnosticParameter.type();
        this.name = field.getName();
        this.description = description;
        this.defaultValue = this.castDiagnosticParameterValue(diagnosticParameter.defaultValue());
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    private Object castDiagnosticParameterValue(String valueToCast) {
        Object value;
        if (this.type == Integer.class) {
            value = Integer.parseInt(valueToCast);
        } else if (this.type == Boolean.class) {
            value = Boolean.parseBoolean(valueToCast);
        } else if (this.type == Float.class) {
            value = Float.valueOf(Float.parseFloat(valueToCast));
        } else if (this.type == String.class) {
            value = valueToCast;
        } else {
            throw new IllegalArgumentException("Unsupported diagnostic parameter type " + this.type);
        }
        return value;
    }

    static List<DiagnosticParameterInfo> createDiagnosticParameters(DiagnosticInfo diagnosticInfo) {
        List parameterInfos = DiagnosticParameterInfo.getParameterByClass((Class)diagnosticInfo.getDiagnosticClass(), (DiagnosticInfo)diagnosticInfo);
        Class superClass = diagnosticInfo.getDiagnosticClass().getSuperclass();
        if (superClass != null) {
            parameterInfos.addAll(DiagnosticParameterInfo.getParameterByClass(superClass, (DiagnosticInfo)diagnosticInfo));
        }
        return parameterInfos;
    }

    private static List<DiagnosticParameterInfo> getParameterByClass(Class<?> clazz, DiagnosticInfo diagnosticInfo) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(DiagnosticParameter.class)).map(field -> new DiagnosticParameterInfo(field, diagnosticInfo.getResourceString(field.getName()))).collect(Collectors.toList());
    }
}

