/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.documentlink;

import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.documentlink.DocumentLinkSupplier;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

@Component
public class DiagnosticDescriptionDocumentLinkSupplier
implements DocumentLinkSupplier {
    private final LanguageServerConfiguration configuration;

    public List<DocumentLink> getDocumentLinks(DocumentContext documentContext) {
        if (!this.configuration.getDocumentLinkOptions().isShowDiagnosticDescription()) {
            return Collections.emptyList();
        }
        Language language = this.configuration.getLanguage();
        return documentContext.getComputedDiagnostics().stream().map(diagnostic -> {
            String diagnosticCode = DiagnosticCode.getStringValue((Either)diagnostic.getCode());
            return new DocumentLink(diagnostic.getRange(), diagnostic.getCodeDescription().getHref(), null, Resources.getResourceString((Language)language, this.getClass(), (String)"tooltip", (Object[])new Object[]{diagnosticCode}));
        }).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticDescriptionDocumentLinkSupplier(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

