/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.folding;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.folding.FoldingRangeSupplier;
import com.github._1c_syntax.bsl.parser.SDBLParser;
import com.github._1c_syntax.bsl.parser.Tokenizer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.FoldingRange;
import org.springframework.stereotype.Component;

@Component
public class QueryPackageFoldingRangeSupplier
implements FoldingRangeSupplier {
    public List<FoldingRange> getFoldingRanges(DocumentContext documentContext) {
        return documentContext.getQueries().stream().map(Tokenizer::getAst).map(SDBLParser.QueryPackageContext::queries).flatMap(Collection::stream).map(QueryPackageFoldingRangeSupplier::toFoldingRange).filter(foldingRange -> foldingRange.getStartLine() != foldingRange.getEndLine()).collect(Collectors.toList());
    }

    private static FoldingRange toFoldingRange(SDBLParser.QueriesContext queriesContext) {
        FoldingRange foldingRange = new FoldingRange(queriesContext.getStart().getLine() - 1, queriesContext.getStop().getLine() - 1);
        foldingRange.setKind("region");
        return foldingRange;
    }
}

