/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.infrastructure;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;
import org.springframework.beans.factory.annotation.Autowired;

public class LanguageClientAwareAppender
extends ConsoleAppender<ILoggingEvent> {
    protected static LanguageClientAwareAppender INSTANCE;
    private static final Map<Level, MessageType> loggingLevels;
    @Nullable
    private LanguageClientHolder clientHolder;

    public LanguageClientAwareAppender() {
        INSTANCE = this;
    }

    protected void writeOut(ILoggingEvent event) throws IOException {
        if (this.clientHolder != null && this.clientHolder.isConnected()) {
            LanguageClient languageClient = (LanguageClient)this.clientHolder.getClient().orElseThrow();
            MessageType messageType = loggingLevels.getOrDefault(event.getLevel(), MessageType.Log);
            String message = "[%s - %s] [%s] [%s]: %s".formatted(event.getLevel(), event.getInstant(), event.getThreadName(), event.getLoggerName(), event.getFormattedMessage());
            MessageParams params = new MessageParams(messageType, message);
            languageClient.logMessage(params);
            return;
        }
        super.writeOut((Object)event);
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientHolder(@Nullable LanguageClientHolder clientHolder) {
        this.clientHolder = clientHolder;
    }

    static {
        loggingLevels = Map.of(Level.TRACE, MessageType.Log, Level.DEBUG, MessageType.Log, Level.ERROR, MessageType.Error, Level.INFO, MessageType.Info, Level.WARN, MessageType.Warning);
    }
}

