/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.inlayhints;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexitySecondaryLocation;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.inlayhints.InlayHintSupplier;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintKind;
import org.eclipse.lsp4j.InlayHintParams;

public abstract class AbstractComplexityInlayHintSupplier
implements InlayHintSupplier {
    private final Map<URI, Set<String>> enabledMethods = new HashMap();

    public List<InlayHint> getInlayHints(DocumentContext documentContext, InlayHintParams params) {
        Set enabledMethodsInFile = this.enabledMethods.getOrDefault(documentContext.getUri(), Collections.emptySet());
        Map cognitiveComplexityLocations = this.getComplexityLocations(documentContext);
        return documentContext.getSymbolTree().getMethodsByName().entrySet().stream().filter(entry -> enabledMethodsInFile.contains(entry.getKey())).map(Map.Entry::getValue).map(methodSymbol -> cognitiveComplexityLocations.getOrDefault(methodSymbol, Collections.emptyList()).stream().map(AbstractComplexityInlayHintSupplier::toInlayHint).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void toggleHints(URI uri, String methodName) {
        Set methodsInFile = this.enabledMethods.computeIfAbsent(uri, uri1 -> new HashSet());
        if (methodsInFile.contains(methodName)) {
            methodsInFile.remove(methodName);
        } else {
            methodsInFile.add(methodName);
        }
    }

    protected abstract Map<MethodSymbol, List<ComplexitySecondaryLocation>> getComplexityLocations(DocumentContext var1);

    private static InlayHint toInlayHint(ComplexitySecondaryLocation complexitySecondaryLocation) {
        InlayHint inlayHint = new InlayHint();
        inlayHint.setPosition(complexitySecondaryLocation.getRange().getStart());
        inlayHint.setPaddingRight(Boolean.TRUE);
        inlayHint.setKind(InlayHintKind.Parameter);
        inlayHint.setLabel(complexitySecondaryLocation.getMessage());
        return inlayHint;
    }
}

