/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.inlayhints;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.hover.MethodSymbolMarkupContentBuilder;
import com.github._1c_syntax.bsl.languageserver.inlayhints.InlayHintSupplier;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintKind;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SourceDefinedMethodCallInlayHintSupplier
implements InlayHintSupplier {
    private static final boolean DEFAULT_SHOW_ALL_PARAMETERS = false;
    private static final boolean DEFAULT_SHOW_PARAMETERS_WITH_THE_SAME_NAME = false;
    private static final boolean DEFAULT_DEFAULT_VALUES = true;
    private final ReferenceIndex referenceIndex;
    private final LanguageServerConfiguration configuration;

    public List<InlayHint> getInlayHints(DocumentContext documentContext, InlayHintParams params) {
        Range range = params.getRange();
        return this.referenceIndex.getReferencesFrom(documentContext.getUri(), SymbolKind.Method).stream().filter(reference -> Ranges.containsPosition((Range)range, (Position)reference.getSelectionRange().getStart())).filter(Reference::isSourceDefinedSymbolReference).map(arg_0 -> this.toInlayHints(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<InlayHint> toInlayHints(Reference reference) {
        MethodSymbol methodSymbol = (MethodSymbol)reference.getSymbol();
        List parameters = methodSymbol.getParameters();
        BSLParser.FileContext ast = reference.getFrom().getOwner().getAst();
        Collection doCalls = Trees.findAllRuleNodes((ParseTree)ast, (int)102);
        return doCalls.stream().map(BSLParser.DoCallContext.class::cast).filter(doCall -> SourceDefinedMethodCallInlayHintSupplier.isRightMethod((BSLParserRuleContext)doCall.getParent(), (Reference)reference)).map(BSLParser.DoCallContext::callParamList).map(BSLParser.CallParamListContext::callParam).map(callParams -> {
            ArrayList<InlayHint> hints = new ArrayList<InlayHint>();
            for (int i = 0; i < parameters.size() && callParams.size() >= i + 1; ++i) {
                ParameterDefinition parameter = (ParameterDefinition)parameters.get(i);
                BSLParser.CallParamContext callParam = (BSLParser.CallParamContext)callParams.get(i);
                String passedValue = callParam.getText();
                if (!this.showParametersWithTheSameName() && StringUtils.containsIgnoreCase((CharSequence)passedValue, (CharSequence)parameter.getName())) continue;
                InlayHint inlayHint = new InlayHint();
                inlayHint.setKind(InlayHintKind.Parameter);
                this.setLabelAndPadding(inlayHint, parameter, passedValue);
                SourceDefinedMethodCallInlayHintSupplier.setPosition((InlayHint)inlayHint, (BSLParser.CallParamContext)callParam);
                SourceDefinedMethodCallInlayHintSupplier.setTooltip((InlayHint)inlayHint, (ParameterDefinition)parameter);
                hints.add(inlayHint);
            }
            return hints;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void setLabelAndPadding(InlayHint inlayHint, ParameterDefinition parameter, String passedValue) {
        ParameterDefinition.DefaultValue defaultValue = parameter.getDefaultValue();
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(parameter.getName());
        if (this.showDefaultValues() && passedValue.isBlank() && !defaultValue.equals((Object)ParameterDefinition.DefaultValue.EMPTY)) {
            labelBuilder.append(" (");
            labelBuilder.append(defaultValue.getValue());
            labelBuilder.append(")");
        } else {
            labelBuilder.append(":");
            inlayHint.setPaddingRight(Boolean.TRUE);
        }
        inlayHint.setLabel(labelBuilder.toString());
    }

    private static void setPosition(InlayHint inlayHint, BSLParser.CallParamContext callParam) {
        Position position = new Position(callParam.getStart().getLine() - 1, callParam.getStart().getCharPositionInLine());
        inlayHint.setPosition(position);
    }

    private static void setTooltip(InlayHint inlayHint, ParameterDefinition parameter) {
        String markdown = MethodSymbolMarkupContentBuilder.parameterToString((ParameterDefinition)parameter);
        MarkupContent tooltip = new MarkupContent("markdown", markdown);
        inlayHint.setTooltip(tooltip);
    }

    private boolean showParametersWithTheSameName() {
        Either parameters = this.configuration.getInlayHintOptions().getParameters().getOrDefault(this.getId(), Either.forLeft((Object)true));
        if (parameters.isLeft()) {
            return false;
        }
        return ((Map)parameters.getRight()).getOrDefault("showParametersWithTheSameName", false);
    }

    private boolean showDefaultValues() {
        Either parameters = this.configuration.getInlayHintOptions().getParameters().getOrDefault(this.getId(), Either.forLeft((Object)true));
        if (parameters.isLeft()) {
            return true;
        }
        return ((Map)parameters.getRight()).getOrDefault("showDefaultValues", true);
    }

    private static boolean isRightMethod(BSLParserRuleContext doCallParent, Reference reference) {
        Range selectionRange = reference.getSelectionRange();
        if (doCallParent instanceof BSLParser.MethodCallContext) {
            BSLParser.MethodCallContext methodCallContext = (BSLParser.MethodCallContext)doCallParent;
            return selectionRange.equals((Object)Ranges.create((ParserRuleContext)methodCallContext.methodName()));
        }
        if (doCallParent instanceof BSLParser.GlobalMethodCallContext) {
            BSLParser.GlobalMethodCallContext globalMethodCallContext = (BSLParser.GlobalMethodCallContext)doCallParent;
            return selectionRange.equals((Object)Ranges.create((ParserRuleContext)globalMethodCallContext.methodName()));
        }
        return false;
    }

    @ConstructorProperties(value={"referenceIndex", "configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SourceDefinedMethodCallInlayHintSupplier(ReferenceIndex referenceIndex, LanguageServerConfiguration configuration) {
        this.referenceIndex = referenceIndex;
        this.configuration = configuration;
    }
}

