/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github._1c_syntax.bsl.languageserver.commands.CommandArguments;
import com.github._1c_syntax.bsl.languageserver.commands.CommandSupplier;
import com.github._1c_syntax.bsl.languageserver.providers.CodeLensProvider;
import com.github._1c_syntax.bsl.languageserver.providers.InlayHintProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.springframework.stereotype.Component;

@Component
public class CommandProvider {
    private final Map<String, CommandSupplier<CommandArguments>> commandSuppliersById;
    private final ObjectMapper objectMapper;
    private final CodeLensProvider codeLensProvider;
    private final InlayHintProvider inlayHintProvider;

    public Object executeCommand(CommandArguments arguments) {
        String commandId = arguments.getId();
        CommandSupplier commandSupplier = (CommandSupplier)this.commandSuppliersById.get(commandId);
        if (commandSupplier == null) {
            throw new RuntimeException("Unknown command id: " + commandId);
        }
        Object result = commandSupplier.execute(arguments).orElse(null);
        CompletableFuture.runAsync(() -> {
            if (commandSupplier.needRefreshInlayHintsAfterExecuteCommand()) {
                this.inlayHintProvider.refreshInlayHints();
            }
            if (commandSupplier.needRefreshCodeLensesAfterExecuteCommand()) {
                this.codeLensProvider.refreshCodeLenses();
            }
        });
        return result;
    }

    public List<String> getCommandIds() {
        return List.copyOf(this.commandSuppliersById.keySet());
    }

    public CommandArguments extractArguments(ExecuteCommandParams executeCommandParams) {
        List rawArguments = executeCommandParams.getArguments();
        if (rawArguments.isEmpty()) {
            throw new RuntimeException("Command arguments is empty");
        }
        Object rawArgument = rawArguments.get(0);
        if (rawArgument instanceof CommandArguments) {
            return (CommandArguments)rawArgument;
        }
        return (CommandArguments)this.objectMapper.readValue(rawArgument.toString(), CommandArguments.class);
    }

    @ConstructorProperties(value={"commandSuppliersById", "objectMapper", "codeLensProvider", "inlayHintProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CommandProvider(Map<String, CommandSupplier<CommandArguments>> commandSuppliersById, ObjectMapper objectMapper, CodeLensProvider codeLensProvider, InlayHintProvider inlayHintProvider) {
        this.commandSuppliersById = commandSuppliersById;
        this.objectMapper = objectMapper;
        this.codeLensProvider = codeLensProvider;
        this.inlayHintProvider = inlayHintProvider;
    }
}

