/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.LanguageClientHolder;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.springframework.stereotype.Component;

@Component
public final class DiagnosticProvider {
    public static final String SOURCE = "bsl-language-server";
    private final LanguageClientHolder clientHolder;

    public void computeAndPublishDiagnostics(DocumentContext documentContext) {
        this.publishDiagnostics(documentContext, () -> ((DocumentContext)documentContext).getDiagnostics());
    }

    public void publishEmptyDiagnosticList(DocumentContext documentContext) {
        this.publishDiagnostics(documentContext, Collections::emptyList);
    }

    private void publishDiagnostics(DocumentContext documentContext, Supplier<List<Diagnostic>> diagnostics) {
        this.clientHolder.execIfConnected(languageClient -> languageClient.publishDiagnostics(new PublishDiagnosticsParams(documentContext.getUri().toString(), (List)diagnostics.get(), Integer.valueOf(documentContext.getVersion()))));
    }

    @ConstructorProperties(value={"clientHolder"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticProvider(LanguageClientHolder clientHolder) {
        this.clientHolder = clientHolder;
    }
}

