/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.hover.MarkupContentBuilder;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceResolver;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.springframework.stereotype.Component;

@Component
public final class HoverProvider {
    private final ReferenceResolver referenceResolver;
    private final Map<SymbolKind, MarkupContentBuilder<Symbol>> markupContentBuilders;

    public Optional<Hover> getHover(DocumentContext documentContext, HoverParams params) {
        Position position = params.getPosition();
        return this.referenceResolver.findReference(documentContext.getUri(), position).flatMap(reference -> {
            Symbol symbol = reference.getSymbol();
            Range range = reference.getSelectionRange();
            return Optional.ofNullable((MarkupContentBuilder)this.markupContentBuilders.get(symbol.getSymbolKind())).map(markupContentBuilder -> markupContentBuilder.getContent(symbol)).map(content -> new Hover(content, range));
        });
    }

    @ConstructorProperties(value={"referenceResolver", "markupContentBuilders"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HoverProvider(ReferenceResolver referenceResolver, Map<SymbolKind, MarkupContentBuilder<Symbol>> markupContentBuilders) {
        this.referenceResolver = referenceResolver;
        this.markupContentBuilders = markupContentBuilders;
    }
}

