/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceResolver;
import com.github._1c_syntax.bsl.languageserver.references.model.OccurrenceType;
import com.github._1c_syntax.bsl.languageserver.references.model.Reference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public final class RenameProvider {
    private final ReferenceResolver referenceResolver;
    private final ReferenceIndex referenceIndex;

    public WorkspaceEdit getRename(DocumentContext documentContext, RenameParams params) {
        Position position = params.getPosition();
        Optional sourceDefinedSymbol = this.referenceResolver.findReference(documentContext.getUri(), position).flatMap(Reference::getSourceDefinedSymbol);
        Map changes = Stream.concat(sourceDefinedSymbol.stream().map(arg_0 -> ((ReferenceIndex)this.referenceIndex).getReferencesTo(arg_0)).flatMap(Collection::stream), sourceDefinedSymbol.stream().map(RenameProvider::referenceOf)).collect(Collectors.groupingBy(ref -> ref.getUri().toString(), RenameProvider.getTexEdits((RenameParams)params)));
        return new WorkspaceEdit(changes);
    }

    private static Reference referenceOf(SourceDefinedSymbol symbol) {
        return Reference.of((SourceDefinedSymbol)symbol, (Symbol)symbol, (Location)new Location(symbol.getOwner().getUri().toString(), symbol.getSelectionRange()), (OccurrenceType)OccurrenceType.DEFINITION);
    }

    public Range getPrepareRename(DocumentContext documentContext, TextDocumentPositionParams params) {
        return this.referenceResolver.findReference(documentContext.getUri(), params.getPosition()).filter(Reference::isSourceDefinedSymbolReference).map(Reference::getSelectionRange).orElse(null);
    }

    private static Collector<Reference, ?, List<TextEdit>> getTexEdits(RenameParams params) {
        return Collectors.mapping(Reference::getSelectionRange, Collectors.mapping(range -> RenameProvider.newTextEdit((RenameParams)params, (Range)range), Collectors.toList()));
    }

    private static TextEdit newTextEdit(RenameParams params, Range range) {
        return new TextEdit(range, params.getNewName());
    }

    @ConstructorProperties(value={"referenceResolver", "referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RenameProvider(ReferenceResolver referenceResolver, ReferenceIndex referenceIndex) {
        this.referenceResolver = referenceResolver;
        this.referenceIndex = referenceIndex;
    }
}

