/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.providers;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SourceDefinedSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.VariableSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.variable.VariableKind;
import com.github._1c_syntax.bsl.languageserver.providers.SymbolProvider;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SymbolProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SymbolProvider.class);
    private final ServerContext context;
    private static final Set<VariableKind> supportedVariableKinds = EnumSet.of(VariableKind.MODULE, VariableKind.GLOBAL);

    public List<? extends WorkspaceSymbol> getSymbols(WorkspaceSymbolParams params) {
        Pattern pattern;
        String queryString = Optional.ofNullable(params.getQuery()).orElse("");
        try {
            pattern = CaseInsensitivePattern.compile((String)queryString);
        }
        catch (PatternSyntaxException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        return this.context.getDocuments().values().stream().flatMap(SymbolProvider::getSymbolPairs).filter(symbolPair -> queryString.isEmpty() || pattern.matcher(((SourceDefinedSymbol)symbolPair.getValue()).getName()).find()).map(SymbolProvider::createWorkspaceSymbol).collect(Collectors.toList());
    }

    private static Stream<Pair<URI, SourceDefinedSymbol>> getSymbolPairs(DocumentContext documentContext) {
        return documentContext.getSymbolTree().getChildrenFlat().stream().filter(SymbolProvider::isSupported).map(symbol -> Pair.of((Object)documentContext.getUri(), (Object)symbol));
    }

    private static boolean isSupported(Symbol symbol) {
        SymbolKind symbolKind = symbol.getSymbolKind();
        switch (1.$SwitchMap$org$eclipse$lsp4j$SymbolKind[symbolKind.ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return supportedVariableKinds.contains(((VariableSymbol)symbol).getKind());
            }
        }
        return false;
    }

    private static WorkspaceSymbol createWorkspaceSymbol(Pair<URI, SourceDefinedSymbol> symbolPair) {
        URI uri = (URI)symbolPair.getKey();
        SourceDefinedSymbol symbol = (SourceDefinedSymbol)symbolPair.getValue();
        Location location = new Location(uri.toString(), symbol.getRange());
        WorkspaceSymbol workspaceSymbol = new WorkspaceSymbol();
        workspaceSymbol.setName(symbol.getName());
        workspaceSymbol.setKind(symbol.getSymbolKind());
        workspaceSymbol.setLocation(Either.forLeft((Object)location));
        workspaceSymbol.setTags(symbol.getTags());
        return workspaceSymbol;
    }

    @ConstructorProperties(value={"context"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SymbolProvider(ServerContext context) {
        this.context = context;
    }
}

